@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetProducerDataSharesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProducerDataShares.
 * @property dataShares An array of all data shares in the producer. See `data_shares` below.
 * @property producerArn Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
 * The following arguments are optional:
 * @property status Status of a datashare in the producer. Valid values are `ACTIVE`, `AUTHORIZED`, `PENDING_AUTHORIZATION`, `DEAUTHORIZED`, and `REJECTED`. Omit this argument to return all statuses.
 */
public data class GetProducerDataSharesPlainArgs(
    public val dataShares: List<GetProducerDataSharesDataShare>? = null,
    public val producerArn: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetProducerDataSharesPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetProducerDataSharesPlainArgs =
        com.pulumi.aws.redshift.inputs.GetProducerDataSharesPlainArgs.builder()
            .dataShares(
                dataShares?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .producerArn(producerArn.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProducerDataSharesPlainArgs].
 */
@PulumiTagMarker
public class GetProducerDataSharesPlainArgsBuilder internal constructor() {
    private var dataShares: List<GetProducerDataSharesDataShare>? = null

    private var producerArn: String? = null

    private var status: String? = null

    /**
     * @param value An array of all data shares in the producer. See `data_shares` below.
     */
    @JvmName("ogssulvkqsfqwsch")
    public suspend fun dataShares(`value`: List<GetProducerDataSharesDataShare>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the producer. See `data_shares` below.
     */
    @JvmName("xetwsyqgmxhhrxxd")
    public suspend fun dataShares(argument: List<suspend GetProducerDataSharesDataShareBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProducerDataSharesDataShareBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the producer. See `data_shares` below.
     */
    @JvmName("jefnaijedkjnspya")
    public suspend fun dataShares(vararg argument: suspend GetProducerDataSharesDataShareBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProducerDataSharesDataShareBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the producer. See `data_shares` below.
     */
    @JvmName("ufpxxwcpiojspavs")
    public suspend fun dataShares(argument: suspend GetProducerDataSharesDataShareBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetProducerDataSharesDataShareBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param values An array of all data shares in the producer. See `data_shares` below.
     */
    @JvmName("bvyovftulmfmkjpq")
    public suspend fun dataShares(vararg values: GetProducerDataSharesDataShare) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataShares = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
     * The following arguments are optional:
     */
    @JvmName("rbavqfqdkicmedcv")
    public suspend fun producerArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.producerArn = mapped
    }

    /**
     * @param value Status of a datashare in the producer. Valid values are `ACTIVE`, `AUTHORIZED`, `PENDING_AUTHORIZATION`, `DEAUTHORIZED`, and `REJECTED`. Omit this argument to return all statuses.
     */
    @JvmName("ludrcgwwhvivavsa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetProducerDataSharesPlainArgs = GetProducerDataSharesPlainArgs(
        dataShares = dataShares,
        producerArn = producerArn ?: throw PulumiNullFieldException("producerArn"),
        status = status,
    )
}
