@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetSubnetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubnetGroup.
 * @property name Name of the cluster subnet group for which information is requested.
 * @property tags Tags associated to the Subnet Group
 */
public data class GetSubnetGroupPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetSubnetGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetSubnetGroupPlainArgs =
        com.pulumi.aws.redshift.inputs.GetSubnetGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSubnetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the cluster subnet group for which information is requested.
     */
    @JvmName("jxqkngmfergjyspk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Tags associated to the Subnet Group
     */
    @JvmName("ckyaftontufwbfje")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags associated to the Subnet Group
     */
    @JvmName("cxvbknjsshqfveyw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSubnetGroupPlainArgs = GetSubnetGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
