@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property pauseCluster An action that runs a `PauseCluster` API operation. Documented below.
 * @property resizeCluster An action that runs a `ResizeCluster` API operation. Documented below.
 * @property resumeCluster An action that runs a `ResumeCluster` API operation. Documented below.
 */
public data class ScheduledActionTargetActionArgs(
    public val pauseCluster: Output<ScheduledActionTargetActionPauseClusterArgs>? = null,
    public val resizeCluster: Output<ScheduledActionTargetActionResizeClusterArgs>? = null,
    public val resumeCluster: Output<ScheduledActionTargetActionResumeClusterArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs =
        com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs.builder()
            .pauseCluster(pauseCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resizeCluster(resizeCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resumeCluster(resumeCluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScheduledActionTargetActionArgs].
 */
@PulumiTagMarker
public class ScheduledActionTargetActionArgsBuilder internal constructor() {
    private var pauseCluster: Output<ScheduledActionTargetActionPauseClusterArgs>? = null

    private var resizeCluster: Output<ScheduledActionTargetActionResizeClusterArgs>? = null

    private var resumeCluster: Output<ScheduledActionTargetActionResumeClusterArgs>? = null

    /**
     * @param value An action that runs a `PauseCluster` API operation. Documented below.
     */
    @JvmName("rnuvvmemjisbviwt")
    public suspend fun pauseCluster(`value`: Output<ScheduledActionTargetActionPauseClusterArgs>) {
        this.pauseCluster = value
    }

    /**
     * @param value An action that runs a `ResizeCluster` API operation. Documented below.
     */
    @JvmName("dxbbjjaqgcgartbe")
    public suspend fun resizeCluster(`value`: Output<ScheduledActionTargetActionResizeClusterArgs>) {
        this.resizeCluster = value
    }

    /**
     * @param value An action that runs a `ResumeCluster` API operation. Documented below.
     */
    @JvmName("yhoywrfnbinykhnc")
    public suspend fun resumeCluster(`value`: Output<ScheduledActionTargetActionResumeClusterArgs>) {
        this.resumeCluster = value
    }

    /**
     * @param value An action that runs a `PauseCluster` API operation. Documented below.
     */
    @JvmName("ykujalfiyamsvsdw")
    public suspend fun pauseCluster(`value`: ScheduledActionTargetActionPauseClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pauseCluster = mapped
    }

    /**
     * @param argument An action that runs a `PauseCluster` API operation. Documented below.
     */
    @JvmName("cxsuxvfkqedvxulq")
    public suspend fun pauseCluster(argument: suspend ScheduledActionTargetActionPauseClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledActionTargetActionPauseClusterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pauseCluster = mapped
    }

    /**
     * @param value An action that runs a `ResizeCluster` API operation. Documented below.
     */
    @JvmName("vfljjsxbptiyswbj")
    public suspend fun resizeCluster(`value`: ScheduledActionTargetActionResizeClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resizeCluster = mapped
    }

    /**
     * @param argument An action that runs a `ResizeCluster` API operation. Documented below.
     */
    @JvmName("sakiuxkceninkypj")
    public suspend fun resizeCluster(argument: suspend ScheduledActionTargetActionResizeClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledActionTargetActionResizeClusterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resizeCluster = mapped
    }

    /**
     * @param value An action that runs a `ResumeCluster` API operation. Documented below.
     */
    @JvmName("tjetanghjcmckrkq")
    public suspend fun resumeCluster(`value`: ScheduledActionTargetActionResumeClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resumeCluster = mapped
    }

    /**
     * @param argument An action that runs a `ResumeCluster` API operation. Documented below.
     */
    @JvmName("kowncjevvfdtdobi")
    public suspend fun resumeCluster(argument: suspend ScheduledActionTargetActionResumeClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledActionTargetActionResumeClusterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resumeCluster = mapped
    }

    internal fun build(): ScheduledActionTargetActionArgs = ScheduledActionTargetActionArgs(
        pauseCluster = pauseCluster,
        resizeCluster = resizeCluster,
        resumeCluster = resumeCluster,
    )
}
