@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property classic A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
 * @property clusterIdentifier The unique identifier for the cluster to resize.
 * @property clusterType The new cluster type for the specified cluster.
 * @property nodeType The new node type for the nodes you are adding.
 * @property numberOfNodes The new number of nodes for the cluster.
 */
public data class ScheduledActionTargetActionResizeClusterArgs(
    public val classic: Output<Boolean>? = null,
    public val clusterIdentifier: Output<String>,
    public val clusterType: Output<String>? = null,
    public val nodeType: Output<String>? = null,
    public val numberOfNodes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs = com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs.builder()
        .classic(classic?.applyValue({ args0 -> args0 }))
        .clusterIdentifier(clusterIdentifier.applyValue({ args0 -> args0 }))
        .clusterType(clusterType?.applyValue({ args0 -> args0 }))
        .nodeType(nodeType?.applyValue({ args0 -> args0 }))
        .numberOfNodes(numberOfNodes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledActionTargetActionResizeClusterArgs].
 */
@PulumiTagMarker
public class ScheduledActionTargetActionResizeClusterArgsBuilder internal constructor() {
    private var classic: Output<Boolean>? = null

    private var clusterIdentifier: Output<String>? = null

    private var clusterType: Output<String>? = null

    private var nodeType: Output<String>? = null

    private var numberOfNodes: Output<Int>? = null

    /**
     * @param value A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
     */
    @JvmName("fkkdtdebvdqqqaag")
    public suspend fun classic(`value`: Output<Boolean>) {
        this.classic = value
    }

    /**
     * @param value The unique identifier for the cluster to resize.
     */
    @JvmName("xhnvekmngjwvvssq")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The new cluster type for the specified cluster.
     */
    @JvmName("rtajlqgsoccswaim")
    public suspend fun clusterType(`value`: Output<String>) {
        this.clusterType = value
    }

    /**
     * @param value The new node type for the nodes you are adding.
     */
    @JvmName("rfnxacnyxgcvdafv")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value The new number of nodes for the cluster.
     */
    @JvmName("bxaisechveuxuukx")
    public suspend fun numberOfNodes(`value`: Output<Int>) {
        this.numberOfNodes = value
    }

    /**
     * @param value A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
     */
    @JvmName("utcumrhbalmsmtgi")
    public suspend fun classic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classic = mapped
    }

    /**
     * @param value The unique identifier for the cluster to resize.
     */
    @JvmName("ldvcijgdtfxnekcu")
    public suspend fun clusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The new cluster type for the specified cluster.
     */
    @JvmName("jcyarcwomrygnyao")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The new node type for the nodes you are adding.
     */
    @JvmName("kertwtofcibirhtm")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value The new number of nodes for the cluster.
     */
    @JvmName("usbewcwcjedbtdyw")
    public suspend fun numberOfNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfNodes = mapped
    }

    internal fun build(): ScheduledActionTargetActionResizeClusterArgs =
        ScheduledActionTargetActionResizeClusterArgs(
            classic = classic,
            clusterIdentifier = clusterIdentifier ?: throw PulumiNullFieldException("clusterIdentifier"),
            clusterType = clusterType,
            nodeType = nodeType,
            numberOfNodes = numberOfNodes,
        )
}
