@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property nodeRole Whether the node is a leader node or a compute node
 * @property privateIpAddress The private IP address of a node within a cluster
 * @property publicIpAddress The public IP address of a node within a cluster
 */
public data class ClusterClusterNode(
    public val nodeRole: String? = null,
    public val privateIpAddress: String? = null,
    public val publicIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.ClusterClusterNode): ClusterClusterNode = ClusterClusterNode(
            nodeRole = javaType.nodeRole().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            publicIpAddress = javaType.publicIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
