@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketName The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
 * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
 * @property enable Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
 * @property logDestinationType The log destination type. An enum with possible values of `s3` and `cloudwatch`.
 * @property logExports The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
 * @property s3KeyPrefix The prefix applied to the log file names.
 */
public data class ClusterLogging(
    public val bucketName: String? = null,
    public val enable: Boolean,
    public val logDestinationType: String? = null,
    public val logExports: List<String>? = null,
    public val s3KeyPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.ClusterLogging): ClusterLogging =
            ClusterLogging(
                bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
                enable = javaType.enable(),
                logDestinationType = javaType.logDestinationType().map({ args0 -> args0 }).orElse(null),
                logExports = javaType.logExports().map({ args0 -> args0 }),
                s3KeyPrefix = javaType.s3KeyPrefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
