@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The Availability Zone.
 * @property networkInterfaceId The network interface identifier.
 * @property privateIpAddress The IPv4 address of the network interface within the subnet.
 * @property subnetId The subnet identifier.
 */
public data class EndpointAccessVpcEndpointNetworkInterface(
    public val availabilityZone: String? = null,
    public val networkInterfaceId: String? = null,
    public val privateIpAddress: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.EndpointAccessVpcEndpointNetworkInterface): EndpointAccessVpcEndpointNetworkInterface = EndpointAccessVpcEndpointNetworkInterface(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
