@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCluster.
 * @property allowVersionUpgrade Whether major version upgrades can be applied during maintenance period
 * @property aquaConfigurationStatus The value represents how the cluster is configured to use AQUA.
 * @property arn ARN of cluster.
 * @property automatedSnapshotRetentionPeriod The backup retention period
 * @property availabilityZone Availability zone of the cluster
 * @property availabilityZoneRelocationEnabled Indicates whether the cluster is able to be relocated to another availability zone.
 * @property bucketName Name of the S3 bucket where the log files are to be stored
 * @property clusterIdentifier Cluster identifier
 * @property clusterNamespaceArn The namespace Amazon Resource Name (ARN) of the cluster
 * @property clusterNodes Nodes in the cluster. Cluster node blocks are documented below
 * @property clusterParameterGroupName The name of the parameter group to be associated with this cluster
 * @property clusterPublicKey Public key for the cluster
 * @property clusterRevisionNumber The cluster revision number
 * @property clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster
 * @property clusterType Cluster type
 * @property clusterVersion
 * @property databaseName Name of the default database in the cluster
 * @property defaultIamRoleArn The ARN for the IAM role that was set as default for the cluster when the cluster was created.
 * @property elasticIp Elastic IP of the cluster
 * @property enableLogging Whether cluster logging is enabled
 * @property encrypted Whether the cluster data is encrypted
 * @property endpoint Cluster endpoint
 * @property enhancedVpcRouting Whether enhanced VPC routing is enabled
 * @property iamRoles IAM roles associated to the cluster
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId KMS encryption key associated to the cluster
 * @property logDestinationType The log destination type.
 * @property logExports Collection of exported log types. Log types include the connection log, user log and user activity log.
 * @property maintenanceTrackName The name of the maintenance track for the restored cluster.
 * @property manualSnapshotRetentionPeriod (Optional)  The default number of days to retain a manual snapshot.
 * @property masterUsername Username for the master DB user
 * @property multiAz If the cluster is a Multi-AZ deployment
 * @property nodeType Cluster node type
 * @property numberOfNodes Number of nodes in the cluster
 * @property port Port the cluster responds on
 * @property preferredMaintenanceWindow The maintenance window
 * @property publiclyAccessible Whether the cluster is publicly accessible
 * @property s3KeyPrefix Folder inside the S3 bucket where the log files are stored
 * @property tags Tags associated to the cluster
 * @property vpcId VPC Id associated with the cluster
 * @property vpcSecurityGroupIds The VPC security group Ids associated with the cluster
 */
public data class GetClusterResult(
    public val allowVersionUpgrade: Boolean,
    public val aquaConfigurationStatus: String,
    public val arn: String,
    public val automatedSnapshotRetentionPeriod: Int,
    public val availabilityZone: String,
    public val availabilityZoneRelocationEnabled: Boolean,
    public val bucketName: String,
    public val clusterIdentifier: String,
    public val clusterNamespaceArn: String,
    public val clusterNodes: List<GetClusterClusterNode>,
    public val clusterParameterGroupName: String,
    public val clusterPublicKey: String,
    public val clusterRevisionNumber: String,
    public val clusterSubnetGroupName: String,
    public val clusterType: String,
    public val clusterVersion: String,
    public val databaseName: String,
    public val defaultIamRoleArn: String,
    public val elasticIp: String,
    public val enableLogging: Boolean,
    public val encrypted: Boolean,
    public val endpoint: String,
    public val enhancedVpcRouting: Boolean,
    public val iamRoles: List<String>,
    public val id: String,
    public val kmsKeyId: String,
    public val logDestinationType: String,
    public val logExports: List<String>,
    public val maintenanceTrackName: String,
    public val manualSnapshotRetentionPeriod: Int,
    public val masterUsername: String,
    public val multiAz: Boolean,
    public val nodeType: String,
    public val numberOfNodes: Int,
    public val port: Int,
    public val preferredMaintenanceWindow: String,
    public val publiclyAccessible: Boolean,
    public val s3KeyPrefix: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vpcSecurityGroupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            allowVersionUpgrade = javaType.allowVersionUpgrade(),
            aquaConfigurationStatus = javaType.aquaConfigurationStatus(),
            arn = javaType.arn(),
            automatedSnapshotRetentionPeriod = javaType.automatedSnapshotRetentionPeriod(),
            availabilityZone = javaType.availabilityZone(),
            availabilityZoneRelocationEnabled = javaType.availabilityZoneRelocationEnabled(),
            bucketName = javaType.bucketName(),
            clusterIdentifier = javaType.clusterIdentifier(),
            clusterNamespaceArn = javaType.clusterNamespaceArn(),
            clusterNodes = javaType.clusterNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.GetClusterClusterNode.Companion.toKotlin(args0)
                })
            }),
            clusterParameterGroupName = javaType.clusterParameterGroupName(),
            clusterPublicKey = javaType.clusterPublicKey(),
            clusterRevisionNumber = javaType.clusterRevisionNumber(),
            clusterSubnetGroupName = javaType.clusterSubnetGroupName(),
            clusterType = javaType.clusterType(),
            clusterVersion = javaType.clusterVersion(),
            databaseName = javaType.databaseName(),
            defaultIamRoleArn = javaType.defaultIamRoleArn(),
            elasticIp = javaType.elasticIp(),
            enableLogging = javaType.enableLogging(),
            encrypted = javaType.encrypted(),
            endpoint = javaType.endpoint(),
            enhancedVpcRouting = javaType.enhancedVpcRouting(),
            iamRoles = javaType.iamRoles().map({ args0 -> args0 }),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            logDestinationType = javaType.logDestinationType(),
            logExports = javaType.logExports().map({ args0 -> args0 }),
            maintenanceTrackName = javaType.maintenanceTrackName(),
            manualSnapshotRetentionPeriod = javaType.manualSnapshotRetentionPeriod(),
            masterUsername = javaType.masterUsername(),
            multiAz = javaType.multiAz(),
            nodeType = javaType.nodeType(),
            numberOfNodes = javaType.numberOfNodes(),
            port = javaType.port(),
            preferredMaintenanceWindow = javaType.preferredMaintenanceWindow(),
            publiclyAccessible = javaType.publiclyAccessible(),
            s3KeyPrefix = javaType.s3KeyPrefix(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
