@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataShareArn ARN (Amazon Resource Name) of the data share.
 * @property managedBy Identifier of a datashare to show its managing entity.
 * @property producerArn ARN (Amazon Resource Name) of the producer.
 */
public data class GetDataSharesDataShare(
    public val dataShareArn: String,
    public val managedBy: String,
    public val producerArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetDataSharesDataShare): GetDataSharesDataShare = GetDataSharesDataShare(
            dataShareArn = javaType.dataShareArn(),
            managedBy = javaType.managedBy(),
            producerArn = javaType.producerArn(),
        )
    }
}
