@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDataShares.
 * @property dataShares An array of all data shares in the current region. See `data_shares` below.
 * @property id AWS region.
 */
public data class GetDataSharesResult(
    public val dataShares: List<GetDataSharesDataShare>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetDataSharesResult): GetDataSharesResult = GetDataSharesResult(
            dataShares = javaType.dataShares().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.GetDataSharesDataShare.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
