@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataShareArn ARN (Amazon Resource Name) of the data share.
 * @property managedBy Identifier of a datashare to show its managing entity.
 * @property producerArn Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
 * The following arguments are optional:
 */
public data class GetProducerDataSharesDataShare(
    public val dataShareArn: String,
    public val managedBy: String,
    public val producerArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetProducerDataSharesDataShare): GetProducerDataSharesDataShare = GetProducerDataSharesDataShare(
            dataShareArn = javaType.dataShareArn(),
            managedBy = javaType.managedBy(),
            producerArn = javaType.producerArn(),
        )
    }
}
