@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProducerDataShares.
 * @property dataShares An array of all data shares in the producer. See `data_shares` below.
 * @property id Producer ARN.
 * @property producerArn ARN (Amazon Resource Name) of the producer.
 * @property status
 */
public data class GetProducerDataSharesResult(
    public val dataShares: List<GetProducerDataSharesDataShare>? = null,
    public val id: String,
    public val producerArn: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetProducerDataSharesResult): GetProducerDataSharesResult = GetProducerDataSharesResult(
            dataShares = javaType.dataShares().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.GetProducerDataSharesDataShare.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            producerArn = javaType.producerArn(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
