@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftdata.kotlin

import com.pulumi.aws.redshiftdata.kotlin.outputs.StatementParameter
import com.pulumi.aws.redshiftdata.kotlin.outputs.StatementParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Statement].
 */
@PulumiTagMarker
public class StatementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StatementArgs = StatementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StatementArgsBuilder.() -> Unit) {
        val builder = StatementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Statement {
        val builtJavaResource = com.pulumi.aws.redshiftdata.Statement(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Statement(builtJavaResource)
    }
}

/**
 * Executes a Redshift Data Statement.
 * ## Example Usage
 * ### cluster_identifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftdata.Statement("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 *     database: exampleAwsRedshiftCluster.databaseName,
 *     dbUser: exampleAwsRedshiftCluster.masterUsername,
 *     sql: "CREATE GROUP group_name;",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftdata.Statement("example",
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"],
 *     database=example_aws_redshift_cluster["databaseName"],
 *     db_user=example_aws_redshift_cluster["masterUsername"],
 *     sql="CREATE GROUP group_name;")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftData.Statement("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *         Database = exampleAwsRedshiftCluster.DatabaseName,
 *         DbUser = exampleAwsRedshiftCluster.MasterUsername,
 *         Sql = "CREATE GROUP group_name;",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftdata.NewStatement(ctx, "example", &redshiftdata.StatementArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 			Database:          pulumi.Any(exampleAwsRedshiftCluster.DatabaseName),
 * 			DbUser:            pulumi.Any(exampleAwsRedshiftCluster.MasterUsername),
 * 			Sql:               pulumi.String("CREATE GROUP group_name;"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .database(exampleAwsRedshiftCluster.databaseName())
 *             .dbUser(exampleAwsRedshiftCluster.masterUsername())
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftdata:Statement
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 *       database: ${exampleAwsRedshiftCluster.databaseName}
 *       dbUser: ${exampleAwsRedshiftCluster.masterUsername}
 *       sql: CREATE GROUP group_name;
 * ```
 * <!--End PulumiCodeChooser -->
 * ### workgroup_name
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftdata.Statement("example", {
 *     workgroupName: exampleAwsRedshiftserverlessWorkgroup.workgroupName,
 *     database: "dev",
 *     sql: "CREATE GROUP group_name;",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftdata.Statement("example",
 *     workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"],
 *     database="dev",
 *     sql="CREATE GROUP group_name;")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftData.Statement("example", new()
 *     {
 *         WorkgroupName = exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
 *         Database = "dev",
 *         Sql = "CREATE GROUP group_name;",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftdata.NewStatement(ctx, "example", &redshiftdata.StatementArgs{
 * 			WorkgroupName: pulumi.Any(exampleAwsRedshiftserverlessWorkgroup.WorkgroupName),
 * 			Database:      pulumi.String("dev"),
 * 			Sql:           pulumi.String("CREATE GROUP group_name;"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .workgroupName(exampleAwsRedshiftserverlessWorkgroup.workgroupName())
 *             .database("dev")
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftdata:Statement
 *     properties:
 *       workgroupName: ${exampleAwsRedshiftserverlessWorkgroup.workgroupName}
 *       database: dev
 *       sql: CREATE GROUP group_name;
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Data Statements using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshiftdata/statement:Statement example example
 * ```
 */
public class Statement internal constructor(
    override val javaResource: com.pulumi.aws.redshiftdata.Statement,
) : KotlinCustomResource(javaResource, StatementMapper) {
    /**
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    public val clusterIdentifier: Output<String>?
        get() = javaResource.clusterIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database.
     */
    public val database: Output<String>
        get() = javaResource.database().applyValue({ args0 -> args0 })

    /**
     * The database user name.
     */
    public val dbUser: Output<String>?
        get() = javaResource.dbUser().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val parameters: Output<List<StatementParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name or ARN of the secret that enables access to the database.
     */
    public val secretArn: Output<String>?
        get() = javaResource.secretArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The SQL statement text to run.
     * The following arguments are optional:
     */
    public val sql: Output<String>
        get() = javaResource.sql().applyValue({ args0 -> args0 })

    /**
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public val statementName: Output<String>?
        get() = javaResource.statementName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    public val withEvent: Output<Boolean>?
        get() = javaResource.withEvent().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    public val workgroupName: Output<String>?
        get() = javaResource.workgroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StatementMapper : ResourceMapper<Statement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftdata.Statement::class == javaResource::class

    override fun map(javaResource: Resource): Statement = Statement(
        javaResource as
            com.pulumi.aws.redshiftdata.Statement,
    )
}

/**
 * @see [Statement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Statement].
 */
public suspend fun statement(name: String, block: suspend StatementResourceBuilder.() -> Unit): Statement {
    val builder = StatementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Statement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun statement(name: String): Statement {
    val builder = StatementResourceBuilder()
    builder.name(name)
    return builder.build()
}
