@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftdata.kotlin

import com.pulumi.aws.redshiftdata.StatementArgs.builder
import com.pulumi.aws.redshiftdata.kotlin.inputs.StatementParameterArgs
import com.pulumi.aws.redshiftdata.kotlin.inputs.StatementParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Executes a Redshift Data Statement.
 * ## Example Usage
 * ### cluster_identifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftdata.Statement("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 *     database: exampleAwsRedshiftCluster.databaseName,
 *     dbUser: exampleAwsRedshiftCluster.masterUsername,
 *     sql: "CREATE GROUP group_name;",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftdata.Statement("example",
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"],
 *     database=example_aws_redshift_cluster["databaseName"],
 *     db_user=example_aws_redshift_cluster["masterUsername"],
 *     sql="CREATE GROUP group_name;")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftData.Statement("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *         Database = exampleAwsRedshiftCluster.DatabaseName,
 *         DbUser = exampleAwsRedshiftCluster.MasterUsername,
 *         Sql = "CREATE GROUP group_name;",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftdata.NewStatement(ctx, "example", &redshiftdata.StatementArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 			Database:          pulumi.Any(exampleAwsRedshiftCluster.DatabaseName),
 * 			DbUser:            pulumi.Any(exampleAwsRedshiftCluster.MasterUsername),
 * 			Sql:               pulumi.String("CREATE GROUP group_name;"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .database(exampleAwsRedshiftCluster.databaseName())
 *             .dbUser(exampleAwsRedshiftCluster.masterUsername())
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftdata:Statement
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 *       database: ${exampleAwsRedshiftCluster.databaseName}
 *       dbUser: ${exampleAwsRedshiftCluster.masterUsername}
 *       sql: CREATE GROUP group_name;
 * ```
 * <!--End PulumiCodeChooser -->
 * ### workgroup_name
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftdata.Statement("example", {
 *     workgroupName: exampleAwsRedshiftserverlessWorkgroup.workgroupName,
 *     database: "dev",
 *     sql: "CREATE GROUP group_name;",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftdata.Statement("example",
 *     workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"],
 *     database="dev",
 *     sql="CREATE GROUP group_name;")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftData.Statement("example", new()
 *     {
 *         WorkgroupName = exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
 *         Database = "dev",
 *         Sql = "CREATE GROUP group_name;",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftdata.NewStatement(ctx, "example", &redshiftdata.StatementArgs{
 * 			WorkgroupName: pulumi.Any(exampleAwsRedshiftserverlessWorkgroup.WorkgroupName),
 * 			Database:      pulumi.String("dev"),
 * 			Sql:           pulumi.String("CREATE GROUP group_name;"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .workgroupName(exampleAwsRedshiftserverlessWorkgroup.workgroupName())
 *             .database("dev")
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftdata:Statement
 *     properties:
 *       workgroupName: ${exampleAwsRedshiftserverlessWorkgroup.workgroupName}
 *       database: dev
 *       sql: CREATE GROUP group_name;
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Data Statements using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshiftdata/statement:Statement example example
 * ```
 * @property clusterIdentifier The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
 * @property database The name of the database.
 * @property dbUser The database user name.
 * @property parameters
 * @property secretArn The name or ARN of the secret that enables access to the database.
 * @property sql The SQL statement text to run.
 * The following arguments are optional:
 * @property statementName The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
 * @property withEvent A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
 * @property workgroupName The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
 */
public data class StatementArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val database: Output<String>? = null,
    public val dbUser: Output<String>? = null,
    public val parameters: Output<List<StatementParameterArgs>>? = null,
    public val secretArn: Output<String>? = null,
    public val sql: Output<String>? = null,
    public val statementName: Output<String>? = null,
    public val withEvent: Output<Boolean>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftdata.StatementArgs> {
    override fun toJava(): com.pulumi.aws.redshiftdata.StatementArgs =
        com.pulumi.aws.redshiftdata.StatementArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secretArn(secretArn?.applyValue({ args0 -> args0 }))
            .sql(sql?.applyValue({ args0 -> args0 }))
            .statementName(statementName?.applyValue({ args0 -> args0 }))
            .withEvent(withEvent?.applyValue({ args0 -> args0 }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatementArgs].
 */
@PulumiTagMarker
public class StatementArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var database: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var parameters: Output<List<StatementParameterArgs>>? = null

    private var secretArn: Output<String>? = null

    private var sql: Output<String>? = null

    private var statementName: Output<String>? = null

    private var withEvent: Output<Boolean>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("scfnermmpulrdfmo")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("riotfrapdomryfpm")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The database user name.
     */
    @JvmName("pijtfecofrdiwfjv")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value
     */
    @JvmName("idfpwdmmcnjumtjm")
    public suspend fun parameters(`value`: Output<List<StatementParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("smqcdvrobdrgyxhd")
    public suspend fun parameters(vararg values: Output<StatementParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("whqlltihpoubefek")
    public suspend fun parameters(values: List<Output<StatementParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("pkjwmlpqhcnxbtep")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value The SQL statement text to run.
     * The following arguments are optional:
     */
    @JvmName("cngqdxnloukuleow")
    public suspend fun sql(`value`: Output<String>) {
        this.sql = value
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("lvvpmxmaqjpderkk")
    public suspend fun statementName(`value`: Output<String>) {
        this.statementName = value
    }

    /**
     * @param value A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    @JvmName("yqcyppwubwjyunwy")
    public suspend fun withEvent(`value`: Output<Boolean>) {
        this.withEvent = value
    }

    /**
     * @param value The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("fqlacgbyxfmfebtx")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("lefyilmsuidvcowk")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("xsrnsapbtwvsklar")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The database user name.
     */
    @JvmName("nvodeuhxwgttfkdu")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value
     */
    @JvmName("jnpiaurqmhvswinp")
    public suspend fun parameters(`value`: List<StatementParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("addrcfdtnwtfkfyr")
    public suspend fun parameters(argument: List<suspend StatementParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StatementParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qhreihmqprwlbiak")
    public suspend fun parameters(vararg argument: suspend StatementParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StatementParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ovtdoelbrrwewqag")
    public suspend fun parameters(argument: suspend StatementParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StatementParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("rmvruooccvboxvda")
    public suspend fun parameters(vararg values: StatementParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("uaesbhqgngfqrrnj")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    /**
     * @param value The SQL statement text to run.
     * The following arguments are optional:
     */
    @JvmName("eifyyakrxfaruefa")
    public suspend fun sql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("xnqhenejokusuqqs")
    public suspend fun statementName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementName = mapped
    }

    /**
     * @param value A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    @JvmName("unlyschytmhrnsbv")
    public suspend fun withEvent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withEvent = mapped
    }

    /**
     * @param value The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("grstcohblqcjpwlj")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): StatementArgs = StatementArgs(
        clusterIdentifier = clusterIdentifier,
        database = database,
        dbUser = dbUser,
        parameters = parameters,
        secretArn = secretArn,
        sql = sql,
        statementName = statementName,
        withEvent = withEvent,
        workgroupName = workgroupName,
    )
}
