@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomDomainAssociation].
 */
@PulumiTagMarker
public class CustomDomainAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDomainAssociationArgs = CustomDomainAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDomainAssociationArgsBuilder.() -> Unit) {
        val builder = CustomDomainAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomDomainAssociation {
        val builtJavaResource =
            com.pulumi.aws.redshiftserverless.CustomDomainAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomDomainAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Redshift Serverless Custom Domain Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.acm.Certificate("example", {domainName: "example.com"});
 * const exampleNamespace = new aws.redshiftserverless.Namespace("example", {namespaceName: "example-namespace"});
 * const exampleWorkgroup = new aws.redshiftserverless.Workgroup("example", {
 *     workgroupName: "example-workgroup",
 *     namespaceName: exampleNamespace.namespaceName,
 * });
 * const exampleCustomDomainAssociation = new aws.redshiftserverless.CustomDomainAssociation("example", {
 *     workgroupName: exampleWorkgroup.workgroupName,
 *     customDomainName: "example.com",
 *     customDomainCertificateArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.acm.Certificate("example", domain_name="example.com")
 * example_namespace = aws.redshiftserverless.Namespace("example", namespace_name="example-namespace")
 * example_workgroup = aws.redshiftserverless.Workgroup("example",
 *     workgroup_name="example-workgroup",
 *     namespace_name=example_namespace.namespace_name)
 * example_custom_domain_association = aws.redshiftserverless.CustomDomainAssociation("example",
 *     workgroup_name=example_workgroup.workgroup_name,
 *     custom_domain_name="example.com",
 *     custom_domain_certificate_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Acm.Certificate("example", new()
 *     {
 *         DomainName = "example.com",
 *     });
 *     var exampleNamespace = new Aws.RedshiftServerless.Namespace("example", new()
 *     {
 *         NamespaceName = "example-namespace",
 *     });
 *     var exampleWorkgroup = new Aws.RedshiftServerless.Workgroup("example", new()
 *     {
 *         WorkgroupName = "example-workgroup",
 *         NamespaceName = exampleNamespace.NamespaceName,
 *     });
 *     var exampleCustomDomainAssociation = new Aws.RedshiftServerless.CustomDomainAssociation("example", new()
 *     {
 *         WorkgroupName = exampleWorkgroup.WorkgroupName,
 *         CustomDomainName = "example.com",
 *         CustomDomainCertificateArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/acm"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := acm.NewCertificate(ctx, "example", &acm.CertificateArgs{
 * 			DomainName: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNamespace, err := redshiftserverless.NewNamespace(ctx, "example", &redshiftserverless.NamespaceArgs{
 * 			NamespaceName: pulumi.String("example-namespace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleWorkgroup, err := redshiftserverless.NewWorkgroup(ctx, "example", &redshiftserverless.WorkgroupArgs{
 * 			WorkgroupName: pulumi.String("example-workgroup"),
 * 			NamespaceName: exampleNamespace.NamespaceName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshiftserverless.NewCustomDomainAssociation(ctx, "example", &redshiftserverless.CustomDomainAssociationArgs{
 * 			WorkgroupName:              exampleWorkgroup.WorkgroupName,
 * 			CustomDomainName:           pulumi.String("example.com"),
 * 			CustomDomainCertificateArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acm.Certificate;
 * import com.pulumi.aws.acm.CertificateArgs;
 * import com.pulumi.aws.redshiftserverless.Namespace;
 * import com.pulumi.aws.redshiftserverless.NamespaceArgs;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.CustomDomainAssociation;
 * import com.pulumi.aws.redshiftserverless.CustomDomainAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Certificate("example", CertificateArgs.builder()
 *             .domainName("example.com")
 *             .build());
 *         var exampleNamespace = new Namespace("exampleNamespace", NamespaceArgs.builder()
 *             .namespaceName("example-namespace")
 *             .build());
 *         var exampleWorkgroup = new Workgroup("exampleWorkgroup", WorkgroupArgs.builder()
 *             .workgroupName("example-workgroup")
 *             .namespaceName(exampleNamespace.namespaceName())
 *             .build());
 *         var exampleCustomDomainAssociation = new CustomDomainAssociation("exampleCustomDomainAssociation", CustomDomainAssociationArgs.builder()
 *             .workgroupName(exampleWorkgroup.workgroupName())
 *             .customDomainName("example.com")
 *             .customDomainCertificateArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:acm:Certificate
 *     properties:
 *       domainName: example.com
 *   exampleNamespace:
 *     type: aws:redshiftserverless:Namespace
 *     name: example
 *     properties:
 *       namespaceName: example-namespace
 *   exampleWorkgroup:
 *     type: aws:redshiftserverless:Workgroup
 *     name: example
 *     properties:
 *       workgroupName: example-workgroup
 *       namespaceName: ${exampleNamespace.namespaceName}
 *   exampleCustomDomainAssociation:
 *     type: aws:redshiftserverless:CustomDomainAssociation
 *     name: example
 *     properties:
 *       workgroupName: ${exampleWorkgroup.workgroupName}
 *       customDomainName: example.com
 *       customDomainCertificateArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Custom Domain Association using the `workgroup_name` and `custom_domain_name`, separated by the coma. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/customDomainAssociation:CustomDomainAssociation example example-workgroup,example.com
 * ```
 */
public class CustomDomainAssociation internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.CustomDomainAssociation,
) : KotlinCustomResource(javaResource, CustomDomainAssociationMapper) {
    /**
     * ARN of the certificate for the custom domain association.
     */
    public val customDomainCertificateArn: Output<String>
        get() = javaResource.customDomainCertificateArn().applyValue({ args0 -> args0 })

    /**
     * Expiration time for the certificate.
     */
    public val customDomainCertificateExpiryTime: Output<String>
        get() = javaResource.customDomainCertificateExpiryTime().applyValue({ args0 -> args0 })

    /**
     * Custom domain to associate with the workgroup.
     */
    public val customDomainName: Output<String>
        get() = javaResource.customDomainName().applyValue({ args0 -> args0 })

    /**
     * Name of the workgroup.
     */
    public val workgroupName: Output<String>
        get() = javaResource.workgroupName().applyValue({ args0 -> args0 })
}

public object CustomDomainAssociationMapper : ResourceMapper<CustomDomainAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.CustomDomainAssociation::class == javaResource::class

    override fun map(javaResource: Resource): CustomDomainAssociation =
        CustomDomainAssociation(
            javaResource as
                com.pulumi.aws.redshiftserverless.CustomDomainAssociation,
        )
}

/**
 * @see [CustomDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDomainAssociation].
 */
public suspend fun customDomainAssociation(
    name: String,
    block: suspend CustomDomainAssociationResourceBuilder.() -> Unit,
): CustomDomainAssociation {
    val builder = CustomDomainAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDomainAssociation(name: String): CustomDomainAssociation {
    val builder = CustomDomainAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
