@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.kotlin.outputs.EndpointAccessVpcEndpoint
import com.pulumi.aws.redshiftserverless.kotlin.outputs.EndpointAccessVpcEndpoint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EndpointAccess].
 */
@PulumiTagMarker
public class EndpointAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointAccessArgs = EndpointAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointAccessArgsBuilder.() -> Unit) {
        val builder = EndpointAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointAccess {
        val builtJavaResource =
            com.pulumi.aws.redshiftserverless.EndpointAccess(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EndpointAccess(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Endpoint Access.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.EndpointAccess("example", {
 *     endpointName: "example",
 *     workgroupName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.EndpointAccess("example",
 *     endpoint_name="example",
 *     workgroup_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.EndpointAccess("example", new()
 *     {
 *         EndpointName = "example",
 *         WorkgroupName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewEndpointAccess(ctx, "example", &redshiftserverless.EndpointAccessArgs{
 * 			EndpointName:  pulumi.String("example"),
 * 			WorkgroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.EndpointAccess;
 * import com.pulumi.aws.redshiftserverless.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess("example", EndpointAccessArgs.builder()
 *             .endpointName("example")
 *             .workgroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:EndpointAccess
 *     properties:
 *       endpointName: example
 *       workgroupName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Endpoint Access using the `endpoint_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/endpointAccess:EndpointAccess example example
 * ```
 */
public class EndpointAccess internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.EndpointAccess,
) : KotlinCustomResource(javaResource, EndpointAccessMapper) {
    /**
     * The DNS address of the VPC endpoint.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Endpoint Access.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the endpoint.
     */
    public val endpointName: Output<String>
        get() = javaResource.endpointName().applyValue({ args0 -> args0 })

    /**
     * The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.
     */
    public val ownerAccount: Output<String>?
        get() = javaResource.ownerAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port that Amazon Redshift Serverless listens on.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * An array of VPC subnet IDs to associate with the endpoint.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
     */
    public val vpcEndpoints: Output<List<EndpointAccessVpcEndpoint>>
        get() = javaResource.vpcEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * An array of security group IDs to associate with the workgroup.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the workgroup.
     */
    public val workgroupName: Output<String>
        get() = javaResource.workgroupName().applyValue({ args0 -> args0 })
}

public object EndpointAccessMapper : ResourceMapper<EndpointAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.EndpointAccess::class == javaResource::class

    override fun map(javaResource: Resource): EndpointAccess = EndpointAccess(
        javaResource as
            com.pulumi.aws.redshiftserverless.EndpointAccess,
    )
}

/**
 * @see [EndpointAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointAccess].
 */
public suspend fun endpointAccess(
    name: String,
    block: suspend EndpointAccessResourceBuilder.() -> Unit,
): EndpointAccess {
    val builder = EndpointAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointAccess(name: String): EndpointAccess {
    val builder = EndpointAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
