@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.EndpointAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Endpoint Access.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.EndpointAccess("example", {
 *     endpointName: "example",
 *     workgroupName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.EndpointAccess("example",
 *     endpoint_name="example",
 *     workgroup_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.EndpointAccess("example", new()
 *     {
 *         EndpointName = "example",
 *         WorkgroupName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewEndpointAccess(ctx, "example", &redshiftserverless.EndpointAccessArgs{
 * 			EndpointName:  pulumi.String("example"),
 * 			WorkgroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.EndpointAccess;
 * import com.pulumi.aws.redshiftserverless.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess("example", EndpointAccessArgs.builder()
 *             .endpointName("example")
 *             .workgroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:EndpointAccess
 *     properties:
 *       endpointName: example
 *       workgroupName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Endpoint Access using the `endpoint_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/endpointAccess:EndpointAccess example example
 * ```
 * @property endpointName The name of the endpoint.
 * @property ownerAccount The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.
 * @property subnetIds An array of VPC subnet IDs to associate with the endpoint.
 * @property vpcSecurityGroupIds An array of security group IDs to associate with the workgroup.
 * @property workgroupName The name of the workgroup.
 */
public data class EndpointAccessArgs(
    public val endpointName: Output<String>? = null,
    public val ownerAccount: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.EndpointAccessArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.EndpointAccessArgs =
        com.pulumi.aws.redshiftserverless.EndpointAccessArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .ownerAccount(ownerAccount?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointAccessArgs].
 */
@PulumiTagMarker
public class EndpointAccessArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var ownerAccount: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("grqfnvogryycscsy")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.
     */
    @JvmName("pykxgqubyynbmfdf")
    public suspend fun ownerAccount(`value`: Output<String>) {
        this.ownerAccount = value
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("gciqdighsebmyofo")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("cqysgopmmxhtxcsb")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("hnbdeurhqutvxtgn")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("vakmdgejfwemnbtm")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("lprybjrswlfdsrpi")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("ndqcuekwcmiqnkir")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The name of the workgroup.
     */
    @JvmName("lngjtpfdftoxwbtq")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("bblxtohkbbekldeg")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.
     */
    @JvmName("trggielbtwygqlyj")
    public suspend fun ownerAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerAccount = mapped
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("oolyabyciurjslcx")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("dsvordvhgtrwrufv")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("rbfebuixrtextdta")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("rgatafltbtgnhmts")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value The name of the workgroup.
     */
    @JvmName("mowudrdqphpprlhj")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): EndpointAccessArgs = EndpointAccessArgs(
        endpointName = endpointName,
        ownerAccount = ownerAccount,
        subnetIds = subnetIds,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        workgroupName = workgroupName,
    )
}
