@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource = com.pulumi.aws.redshiftserverless.Namespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Namespace(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Namespace.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Namespace("example", {namespaceName: "concurrency-scaling"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Namespace("example", namespace_name="concurrency-scaling")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Namespace("example", new()
 *     {
 *         NamespaceName = "concurrency-scaling",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewNamespace(ctx, "example", &redshiftserverless.NamespaceArgs{
 * 			NamespaceName: pulumi.String("concurrency-scaling"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Namespace;
 * import com.pulumi.aws.redshiftserverless.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Namespace
 *     properties:
 *       namespaceName: concurrency-scaling
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Namespaces using the `namespace_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/namespace:Namespace example example
 * ```
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    public val adminPasswordSecretArn: Output<String>
        get() = javaResource.adminPasswordSecretArn().applyValue({ args0 -> args0 })

    /**
     * ID of the KMS key used to encrypt the namespace's admin credentials secret.
     */
    public val adminPasswordSecretKmsKeyId: Output<String>
        get() = javaResource.adminPasswordSecretKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The password of the administrator for the first database created in the namespace.
     * Conflicts with `manage_admin_password`.
     */
    public val adminUserPassword: Output<String>?
        get() = javaResource.adminUserPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of the administrator for the first database created in the namespace.
     */
    public val adminUsername: Output<String>
        get() = javaResource.adminUsername().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Namespace.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the first database created in the namespace.
     */
    public val dbName: Output<String>
        get() = javaResource.dbName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
     */
    public val defaultIamRoleArn: Output<String>?
        get() = javaResource.defaultIamRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IAM roles to associate with the namespace.
     */
    public val iamRoles: Output<List<String>>
        get() = javaResource.iamRoles().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    public val logExports: Output<List<String>>?
        get() = javaResource.logExports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Whether to use AWS SecretManager to manage namespace's admin credentials.
     * Conflicts with `admin_user_password`.
     */
    public val manageAdminPassword: Output<Boolean>?
        get() = javaResource.manageAdminPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Redshift Namespace ID.
     */
    public val namespaceId: Output<String>
        get() = javaResource.namespaceId().applyValue({ args0 -> args0 })

    /**
     * The name of the namespace.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.aws.redshiftserverless.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
