@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Namespace.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Namespace("example", {namespaceName: "concurrency-scaling"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Namespace("example", namespace_name="concurrency-scaling")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Namespace("example", new()
 *     {
 *         NamespaceName = "concurrency-scaling",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewNamespace(ctx, "example", &redshiftserverless.NamespaceArgs{
 * 			NamespaceName: pulumi.String("concurrency-scaling"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Namespace;
 * import com.pulumi.aws.redshiftserverless.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Namespace
 *     properties:
 *       namespaceName: concurrency-scaling
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Namespaces using the `namespace_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/namespace:Namespace example example
 * ```
 * @property adminPasswordSecretKmsKeyId ID of the KMS key used to encrypt the namespace's admin credentials secret.
 * @property adminUserPassword The password of the administrator for the first database created in the namespace.
 * Conflicts with `manage_admin_password`.
 * @property adminUsername The username of the administrator for the first database created in the namespace.
 * @property dbName The name of the first database created in the namespace.
 * @property defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
 * @property iamRoles A list of IAM roles to associate with the namespace.
 * @property kmsKeyId The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
 * @property logExports The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
 * @property manageAdminPassword Whether to use AWS SecretManager to manage namespace's admin credentials.
 * Conflicts with `admin_user_password`.
 * @property namespaceName The name of the namespace.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NamespaceArgs(
    public val adminPasswordSecretKmsKeyId: Output<String>? = null,
    public val adminUserPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val dbName: Output<String>? = null,
    public val defaultIamRoleArn: Output<String>? = null,
    public val iamRoles: Output<List<String>>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val logExports: Output<List<String>>? = null,
    public val manageAdminPassword: Output<Boolean>? = null,
    public val namespaceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.NamespaceArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.NamespaceArgs =
        com.pulumi.aws.redshiftserverless.NamespaceArgs.builder()
            .adminPasswordSecretKmsKeyId(adminPasswordSecretKmsKeyId?.applyValue({ args0 -> args0 }))
            .adminUserPassword(adminUserPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .defaultIamRoleArn(defaultIamRoleArn?.applyValue({ args0 -> args0 }))
            .iamRoles(iamRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logExports(logExports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .manageAdminPassword(manageAdminPassword?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var adminPasswordSecretKmsKeyId: Output<String>? = null

    private var adminUserPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var dbName: Output<String>? = null

    private var defaultIamRoleArn: Output<String>? = null

    private var iamRoles: Output<List<String>>? = null

    private var kmsKeyId: Output<String>? = null

    private var logExports: Output<List<String>>? = null

    private var manageAdminPassword: Output<Boolean>? = null

    private var namespaceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID of the KMS key used to encrypt the namespace's admin credentials secret.
     */
    @JvmName("jaaxktpbvlymxbyu")
    public suspend fun adminPasswordSecretKmsKeyId(`value`: Output<String>) {
        this.adminPasswordSecretKmsKeyId = value
    }

    /**
     * @param value The password of the administrator for the first database created in the namespace.
     * Conflicts with `manage_admin_password`.
     */
    @JvmName("obygvlnftwpkkbdp")
    public suspend fun adminUserPassword(`value`: Output<String>) {
        this.adminUserPassword = value
    }

    /**
     * @param value The username of the administrator for the first database created in the namespace.
     */
    @JvmName("bowhrbsfsrogusmu")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value The name of the first database created in the namespace.
     */
    @JvmName("oooknlgcsnrrtjet")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
     */
    @JvmName("scwcyarkfgppvtyg")
    public suspend fun defaultIamRoleArn(`value`: Output<String>) {
        this.defaultIamRoleArn = value
    }

    /**
     * @param value A list of IAM roles to associate with the namespace.
     */
    @JvmName("bdlouxsyhnkkyiqr")
    public suspend fun iamRoles(`value`: Output<List<String>>) {
        this.iamRoles = value
    }

    @JvmName("hxatervwohdhppkf")
    public suspend fun iamRoles(vararg values: Output<String>) {
        this.iamRoles = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM roles to associate with the namespace.
     */
    @JvmName("dhbmwceoevchgitv")
    public suspend fun iamRoles(values: List<Output<String>>) {
        this.iamRoles = Output.all(values)
    }

    /**
     * @param value The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    @JvmName("qbihynbgtlocxgsj")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("fpgirtkbxvrghfwp")
    public suspend fun logExports(`value`: Output<List<String>>) {
        this.logExports = value
    }

    @JvmName("xfuyhvjphusuilqo")
    public suspend fun logExports(vararg values: Output<String>) {
        this.logExports = Output.all(values.asList())
    }

    /**
     * @param values The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("kcsciulilgjbingt")
    public suspend fun logExports(values: List<Output<String>>) {
        this.logExports = Output.all(values)
    }

    /**
     * @param value Whether to use AWS SecretManager to manage namespace's admin credentials.
     * Conflicts with `admin_user_password`.
     */
    @JvmName("ifrkiaxounkktauo")
    public suspend fun manageAdminPassword(`value`: Output<Boolean>) {
        this.manageAdminPassword = value
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("onwtbxvwnbaaactr")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ywicrahnqlnkuwbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the KMS key used to encrypt the namespace's admin credentials secret.
     */
    @JvmName("ljaqjrhorgltwwju")
    public suspend fun adminPasswordSecretKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPasswordSecretKmsKeyId = mapped
    }

    /**
     * @param value The password of the administrator for the first database created in the namespace.
     * Conflicts with `manage_admin_password`.
     */
    @JvmName("ppjmyetwhwsrfnvb")
    public suspend fun adminUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserPassword = mapped
    }

    /**
     * @param value The username of the administrator for the first database created in the namespace.
     */
    @JvmName("ecwoystxxmibljot")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value The name of the first database created in the namespace.
     */
    @JvmName("gpfcokcevjpgadja")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
     */
    @JvmName("dsasfkywbwgjkikp")
    public suspend fun defaultIamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIamRoleArn = mapped
    }

    /**
     * @param value A list of IAM roles to associate with the namespace.
     */
    @JvmName("dhngrfyhdayymufr")
    public suspend fun iamRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param values A list of IAM roles to associate with the namespace.
     */
    @JvmName("ebqefcjfuedxhbhd")
    public suspend fun iamRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param value The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    @JvmName("ufxuoklgllwmieep")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("kenbwbolnitdffea")
    public suspend fun logExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param values The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("onxebrdfuwkeudsf")
    public suspend fun logExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param value Whether to use AWS SecretManager to manage namespace's admin credentials.
     * Conflicts with `admin_user_password`.
     */
    @JvmName("syivgwowfvjqhtse")
    public suspend fun manageAdminPassword(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageAdminPassword = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("cqcpomyldyycsfxj")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("owrxxlldmtoedtao")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nrvcxqsbtbbhxppf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId,
        adminUserPassword = adminUserPassword,
        adminUsername = adminUsername,
        dbName = dbName,
        defaultIamRoleArn = defaultIamRoleArn,
        iamRoles = iamRoles,
        kmsKeyId = kmsKeyId,
        logExports = logExports,
        manageAdminPassword = manageAdminPassword,
        namespaceName = namespaceName,
        tags = tags,
    )
}
