@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions.getCredentialsPlain
import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions.getNamespacePlain
import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions.getWorkgroupPlain
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetCredentialsPlainArgs
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetCredentialsPlainArgsBuilder
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetWorkgroupPlainArgs
import com.pulumi.aws.redshiftserverless.kotlin.inputs.GetWorkgroupPlainArgsBuilder
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetCredentialsResult
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetNamespaceResult
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetWorkgroupResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetCredentialsResult.Companion.toKotlin as getCredentialsResultToKotlin
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.aws.redshiftserverless.kotlin.outputs.GetWorkgroupResult.Companion.toKotlin as getWorkgroupResultToKotlin

public object RedshiftserverlessFunctions {
    /**
     * Provides redshift serverless temporary credentials for a workgroup.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshiftserverless.getCredentials({
     *     workgroupName: exampleAwsRedshiftserverlessWorkgroup.workgroupName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshiftserverless.get_credentials(workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedshiftServerless.GetCredentials.Invoke(new()
     *     {
     *         WorkgroupName = exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshiftserverless.GetCredentials(ctx, &redshiftserverless.GetCredentialsArgs{
     * 			WorkgroupName: exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions;
     * import com.pulumi.aws.redshiftserverless.inputs.GetCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftserverlessFunctions.getCredentials(GetCredentialsArgs.builder()
     *             .workgroupName(exampleAwsRedshiftserverlessWorkgroup.workgroupName())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshiftserverless:getCredentials
     *       Arguments:
     *         workgroupName: ${exampleAwsRedshiftserverlessWorkgroup.workgroupName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCredentials.
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: GetCredentialsPlainArgs): GetCredentialsResult =
        getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getCredentials].
     * @param dbName The name of the database to get temporary authorization to log on to.
     * @param durationSeconds The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
     * @param workgroupName The name of the workgroup associated with the database.
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(
        dbName: String? = null,
        durationSeconds: Int? = null,
        workgroupName: String,
    ): GetCredentialsResult {
        val argument = GetCredentialsPlainArgs(
            dbName = dbName,
            durationSeconds = durationSeconds,
            workgroupName = workgroupName,
        )
        return getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshiftserverless&#46;kotlin&#46;inputs&#46;GetCredentialsPlainArgs].
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: suspend GetCredentialsPlainArgsBuilder.() -> Unit): GetCredentialsResult {
        val builder = GetCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialsResultToKotlin(getCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Redshift Serverless Namespace.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshiftserverless.getNamespace({
     *     namespaceName: "example-namespace",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshiftserverless.get_namespace(namespace_name="example-namespace")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedshiftServerless.GetNamespace.Invoke(new()
     *     {
     *         NamespaceName = "example-namespace",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshiftserverless.LookupNamespace(ctx, &redshiftserverless.LookupNamespaceArgs{
     * 			NamespaceName: "example-namespace",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions;
     * import com.pulumi.aws.redshiftserverless.inputs.GetNamespaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftserverlessFunctions.getNamespace(GetNamespaceArgs.builder()
     *             .namespaceName("example-namespace")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshiftserverless:getNamespace
     *       Arguments:
     *         namespaceName: example-namespace
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespace.
     * @return A collection of values returned by getNamespace.
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName The name of the namespace.
     * @return A collection of values returned by getNamespace.
     */
    public suspend fun getNamespace(namespaceName: String): GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshiftserverless&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return A collection of values returned by getNamespace.
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit): GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Redshift Serverless Workgroup.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshiftserverless.getWorkgroup({
     *     workgroupName: exampleAwsRedshiftserverlessWorkgroup.workgroupName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshiftserverless.get_workgroup(workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedshiftServerless.GetWorkgroup.Invoke(new()
     *     {
     *         WorkgroupName = exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshiftserverless.LookupWorkgroup(ctx, &redshiftserverless.LookupWorkgroupArgs{
     * 			WorkgroupName: exampleAwsRedshiftserverlessWorkgroup.WorkgroupName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshiftserverless.RedshiftserverlessFunctions;
     * import com.pulumi.aws.redshiftserverless.inputs.GetWorkgroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftserverlessFunctions.getWorkgroup(GetWorkgroupArgs.builder()
     *             .workgroupName(exampleAwsRedshiftserverlessWorkgroup.workgroupName())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshiftserverless:getWorkgroup
     *       Arguments:
     *         workgroupName: ${exampleAwsRedshiftserverlessWorkgroup.workgroupName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWorkgroup.
     * @return A collection of values returned by getWorkgroup.
     */
    public suspend fun getWorkgroup(argument: GetWorkgroupPlainArgs): GetWorkgroupResult =
        getWorkgroupResultToKotlin(getWorkgroupPlain(argument.toJava()).await())

    /**
     * @see [getWorkgroup].
     * @param workgroupName The name of the workgroup associated with the database.
     * @return A collection of values returned by getWorkgroup.
     */
    public suspend fun getWorkgroup(workgroupName: String): GetWorkgroupResult {
        val argument = GetWorkgroupPlainArgs(
            workgroupName = workgroupName,
        )
        return getWorkgroupResultToKotlin(getWorkgroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkgroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshiftserverless&#46;kotlin&#46;inputs&#46;GetWorkgroupPlainArgs].
     * @return A collection of values returned by getWorkgroup.
     */
    public suspend fun getWorkgroup(argument: suspend GetWorkgroupPlainArgsBuilder.() -> Unit): GetWorkgroupResult {
        val builder = GetWorkgroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkgroupResultToKotlin(getWorkgroupPlain(builtArgument.toJava()).await())
    }
}
