@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Resource Policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.ResourcePolicy("example", {
 *     resourceArn: exampleAwsRedshiftserverlessSnapshot.arn,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Principal: {
 *                 AWS: ["12345678901"],
 *             },
 *             Action: ["redshift-serverless:RestoreFromSnapshot"],
 *             Sid: "",
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.ResourcePolicy("example",
 *     resource_arn=example_aws_redshiftserverless_snapshot["arn"],
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "AWS": ["12345678901"],
 *             },
 *             "Action": ["redshift-serverless:RestoreFromSnapshot"],
 *             "Sid": "",
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = exampleAwsRedshiftserverlessSnapshot.Arn,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = new[]
 *                         {
 *                             "12345678901",
 *                         },
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "redshift-serverless:RestoreFromSnapshot",
 *                     },
 *                     ["Sid"] = "",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": []string{
 * 							"12345678901",
 * 						},
 * 					},
 * 					"Action": []string{
 * 						"redshift-serverless:RestoreFromSnapshot",
 * 					},
 * 					"Sid": "",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = redshiftserverless.NewResourcePolicy(ctx, "example", &redshiftserverless.ResourcePolicyArgs{
 * 			ResourceArn: pulumi.Any(exampleAwsRedshiftserverlessSnapshot.Arn),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicy;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleAwsRedshiftserverlessSnapshot.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray("12345678901"))
 *                         )),
 *                         jsonProperty("Action", jsonArray("redshift-serverless:RestoreFromSnapshot")),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:ResourcePolicy
 *     properties:
 *       resourceArn: ${exampleAwsRedshiftserverlessSnapshot.arn}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Principal:
 *                 AWS:
 *                   - '12345678901'
 *               Action:
 *                 - redshift-serverless:RestoreFromSnapshot
 *               Sid:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Resource Policies using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/resourcePolicy:ResourcePolicy example example
 * ```
 * @property policy The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
 * @property resourceArn The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.ResourcePolicyArgs =
        com.pulumi.aws.redshiftserverless.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
     */
    @JvmName("ccodroqbsneyngya")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("mrqkyuswnvcwrysa")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
     */
    @JvmName("gcdegysmbajnunec")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("awaptllghixxcvms")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
