@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.aws.redshiftserverless.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Snapshot("example", {
 *     namespaceName: exampleAwsRedshiftserverlessWorkgroup.namespaceName,
 *     snapshotName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Snapshot("example",
 *     namespace_name=example_aws_redshiftserverless_workgroup["namespaceName"],
 *     snapshot_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Snapshot("example", new()
 *     {
 *         NamespaceName = exampleAwsRedshiftserverlessWorkgroup.NamespaceName,
 *         SnapshotName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewSnapshot(ctx, "example", &redshiftserverless.SnapshotArgs{
 * 			NamespaceName: pulumi.Any(exampleAwsRedshiftserverlessWorkgroup.NamespaceName),
 * 			SnapshotName:  pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Snapshot;
 * import com.pulumi.aws.redshiftserverless.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Snapshot("example", SnapshotArgs.builder()
 *             .namespaceName(exampleAwsRedshiftserverlessWorkgroup.namespaceName())
 *             .snapshotName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Snapshot
 *     properties:
 *       namespaceName: ${exampleAwsRedshiftserverlessWorkgroup.namespaceName}
 *       snapshotName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Snapshots using the `snapshot_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/snapshot:Snapshot example example
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     */
    public val accountsWithProvisionedRestoreAccesses: Output<List<String>>
        get() = javaResource.accountsWithProvisionedRestoreAccesses().applyValue({ args0 ->
            args0.map({ args0 -> args0 })
        })

    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     */
    public val accountsWithRestoreAccesses: Output<List<String>>
        get() = javaResource.accountsWithRestoreAccesses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The username of the database within a snapshot.
     */
    public val adminUsername: Output<String>
        get() = javaResource.adminUsername().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The unique identifier of the KMS key used to encrypt the snapshot.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     */
    public val namespaceArn: Output<String>
        get() = javaResource.namespaceArn().applyValue({ args0 -> args0 })

    /**
     * The namespace to create a snapshot for.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })

    /**
     * The owner Amazon Web Services; account of the snapshot.
     */
    public val ownerAccount: Output<String>
        get() = javaResource.ownerAccount().applyValue({ args0 -> args0 })

    /**
     * How long to retain the created snapshot. Default value is `-1`.
     */
    public val retentionPeriod: Output<Int>?
        get() = javaResource.retentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the snapshot.
     */
    public val snapshotName: Output<String>
        get() = javaResource.snapshotName().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.aws.redshiftserverless.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
