@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Snapshot("example", {
 *     namespaceName: exampleAwsRedshiftserverlessWorkgroup.namespaceName,
 *     snapshotName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Snapshot("example",
 *     namespace_name=example_aws_redshiftserverless_workgroup["namespaceName"],
 *     snapshot_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Snapshot("example", new()
 *     {
 *         NamespaceName = exampleAwsRedshiftserverlessWorkgroup.NamespaceName,
 *         SnapshotName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewSnapshot(ctx, "example", &redshiftserverless.SnapshotArgs{
 * 			NamespaceName: pulumi.Any(exampleAwsRedshiftserverlessWorkgroup.NamespaceName),
 * 			SnapshotName:  pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Snapshot;
 * import com.pulumi.aws.redshiftserverless.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Snapshot("example", SnapshotArgs.builder()
 *             .namespaceName(exampleAwsRedshiftserverlessWorkgroup.namespaceName())
 *             .snapshotName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Snapshot
 *     properties:
 *       namespaceName: ${exampleAwsRedshiftserverlessWorkgroup.namespaceName}
 *       snapshotName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Snapshots using the `snapshot_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/snapshot:Snapshot example example
 * ```
 * @property namespaceName The namespace to create a snapshot for.
 * @property retentionPeriod How long to retain the created snapshot. Default value is `-1`.
 * @property snapshotName The name of the snapshot.
 */
public data class SnapshotArgs(
    public val namespaceName: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val snapshotName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.SnapshotArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.SnapshotArgs =
        com.pulumi.aws.redshiftserverless.SnapshotArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    private var snapshotName: Output<String>? = null

    /**
     * @param value The namespace to create a snapshot for.
     */
    @JvmName("ueasofdvrsbxgstn")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value How long to retain the created snapshot. Default value is `-1`.
     */
    @JvmName("vetnemahlkjipxcl")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("phchqrotinkkmcvn")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value The namespace to create a snapshot for.
     */
    @JvmName("dpvobujxqlhxwqdp")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value How long to retain the created snapshot. Default value is `-1`.
     */
    @JvmName("kdtwuddlnfehjahf")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("nsluayqutgjcjjdm")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        namespaceName = namespaceName,
        retentionPeriod = retentionPeriod,
        snapshotName = snapshotName,
    )
}
