@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UsageLimit].
 */
@PulumiTagMarker
public class UsageLimitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsageLimitArgs = UsageLimitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsageLimitArgsBuilder.() -> Unit) {
        val builder = UsageLimitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UsageLimit {
        val builtJavaResource = com.pulumi.aws.redshiftserverless.UsageLimit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsageLimit(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Usage Limit.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Workgroup("example", {
 *     namespaceName: exampleAwsRedshiftserverlessNamespace.namespaceName,
 *     workgroupName: "example",
 * });
 * const exampleUsageLimit = new aws.redshiftserverless.UsageLimit("example", {
 *     resourceArn: example.arn,
 *     usageType: "serverless-compute",
 *     amount: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Workgroup("example",
 *     namespace_name=example_aws_redshiftserverless_namespace["namespaceName"],
 *     workgroup_name="example")
 * example_usage_limit = aws.redshiftserverless.UsageLimit("example",
 *     resource_arn=example.arn,
 *     usage_type="serverless-compute",
 *     amount=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Workgroup("example", new()
 *     {
 *         NamespaceName = exampleAwsRedshiftserverlessNamespace.NamespaceName,
 *         WorkgroupName = "example",
 *     });
 *     var exampleUsageLimit = new Aws.RedshiftServerless.UsageLimit("example", new()
 *     {
 *         ResourceArn = example.Arn,
 *         UsageType = "serverless-compute",
 *         Amount = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := redshiftserverless.NewWorkgroup(ctx, "example", &redshiftserverless.WorkgroupArgs{
 * 			NamespaceName: pulumi.Any(exampleAwsRedshiftserverlessNamespace.NamespaceName),
 * 			WorkgroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshiftserverless.NewUsageLimit(ctx, "example", &redshiftserverless.UsageLimitArgs{
 * 			ResourceArn: example.Arn,
 * 			UsageType:   pulumi.String("serverless-compute"),
 * 			Amount:      pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.UsageLimit;
 * import com.pulumi.aws.redshiftserverless.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .namespaceName(exampleAwsRedshiftserverlessNamespace.namespaceName())
 *             .workgroupName("example")
 *             .build());
 *         var exampleUsageLimit = new UsageLimit("exampleUsageLimit", UsageLimitArgs.builder()
 *             .resourceArn(example.arn())
 *             .usageType("serverless-compute")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Workgroup
 *     properties:
 *       namespaceName: ${exampleAwsRedshiftserverlessNamespace.namespaceName}
 *       workgroupName: example
 *   exampleUsageLimit:
 *     type: aws:redshiftserverless:UsageLimit
 *     name: example
 *     properties:
 *       resourceArn: ${example.arn}
 *       usageType: serverless-compute
 *       amount: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
 * ```
 */
public class UsageLimit internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.UsageLimit,
) : KotlinCustomResource(javaResource, UsageLimitMapper) {
    /**
     * The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    public val amount: Output<Int>
        get() = javaResource.amount().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    public val breachAction: Output<String>?
        get() = javaResource.breachAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    public val usageType: Output<String>
        get() = javaResource.usageType().applyValue({ args0 -> args0 })
}

public object UsageLimitMapper : ResourceMapper<UsageLimit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.UsageLimit::class == javaResource::class

    override fun map(javaResource: Resource): UsageLimit = UsageLimit(
        javaResource as
            com.pulumi.aws.redshiftserverless.UsageLimit,
    )
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsageLimit].
 */
public suspend fun usageLimit(name: String, block: suspend UsageLimitResourceBuilder.() -> Unit): UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usageLimit(name: String): UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    return builder.build()
}
