@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.UsageLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Usage Limit.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Workgroup("example", {
 *     namespaceName: exampleAwsRedshiftserverlessNamespace.namespaceName,
 *     workgroupName: "example",
 * });
 * const exampleUsageLimit = new aws.redshiftserverless.UsageLimit("example", {
 *     resourceArn: example.arn,
 *     usageType: "serverless-compute",
 *     amount: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Workgroup("example",
 *     namespace_name=example_aws_redshiftserverless_namespace["namespaceName"],
 *     workgroup_name="example")
 * example_usage_limit = aws.redshiftserverless.UsageLimit("example",
 *     resource_arn=example.arn,
 *     usage_type="serverless-compute",
 *     amount=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Workgroup("example", new()
 *     {
 *         NamespaceName = exampleAwsRedshiftserverlessNamespace.NamespaceName,
 *         WorkgroupName = "example",
 *     });
 *     var exampleUsageLimit = new Aws.RedshiftServerless.UsageLimit("example", new()
 *     {
 *         ResourceArn = example.Arn,
 *         UsageType = "serverless-compute",
 *         Amount = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := redshiftserverless.NewWorkgroup(ctx, "example", &redshiftserverless.WorkgroupArgs{
 * 			NamespaceName: pulumi.Any(exampleAwsRedshiftserverlessNamespace.NamespaceName),
 * 			WorkgroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshiftserverless.NewUsageLimit(ctx, "example", &redshiftserverless.UsageLimitArgs{
 * 			ResourceArn: example.Arn,
 * 			UsageType:   pulumi.String("serverless-compute"),
 * 			Amount:      pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.UsageLimit;
 * import com.pulumi.aws.redshiftserverless.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .namespaceName(exampleAwsRedshiftserverlessNamespace.namespaceName())
 *             .workgroupName("example")
 *             .build());
 *         var exampleUsageLimit = new UsageLimit("exampleUsageLimit", UsageLimitArgs.builder()
 *             .resourceArn(example.arn())
 *             .usageType("serverless-compute")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Workgroup
 *     properties:
 *       namespaceName: ${exampleAwsRedshiftserverlessNamespace.namespaceName}
 *       workgroupName: example
 *   exampleUsageLimit:
 *     type: aws:redshiftserverless:UsageLimit
 *     name: example
 *     properties:
 *       resourceArn: ${example.arn}
 *       usageType: serverless-compute
 *       amount: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
 * ```
 * @property amount The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
 * @property breachAction The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
 * @property period The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
 * @property resourceArn The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
 * @property usageType The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
 */
public data class UsageLimitArgs(
    public val amount: Output<Int>? = null,
    public val breachAction: Output<String>? = null,
    public val period: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
    public val usageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.UsageLimitArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.UsageLimitArgs =
        com.pulumi.aws.redshiftserverless.UsageLimitArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .breachAction(breachAction?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .usageType(usageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsageLimitArgs].
 */
@PulumiTagMarker
public class UsageLimitArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var breachAction: Output<String>? = null

    private var period: Output<String>? = null

    private var resourceArn: Output<String>? = null

    private var usageType: Output<String>? = null

    /**
     * @param value The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    @JvmName("thhdwgvpiwengast")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    @JvmName("pkuhqmttbdjlnktj")
    public suspend fun breachAction(`value`: Output<String>) {
        this.breachAction = value
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    @JvmName("pqdpeaimauojiyag")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    @JvmName("xjumlsueyefwbsnc")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    @JvmName("qblcrjehnosokbwh")
    public suspend fun usageType(`value`: Output<String>) {
        this.usageType = value
    }

    /**
     * @param value The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    @JvmName("sfryktrawygrxvbd")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    @JvmName("hqrwbplcsomgdrjl")
    public suspend fun breachAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.breachAction = mapped
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    @JvmName("fflcoghwtjqgeeuj")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    @JvmName("fdyvxmikxnomhavn")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    @JvmName("vssqnexkyfxqsxel")
    public suspend fun usageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    internal fun build(): UsageLimitArgs = UsageLimitArgs(
        amount = amount,
        breachAction = breachAction,
        period = period,
        resourceArn = resourceArn,
        usageType = usageType,
    )
}
