@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.WorkgroupArgs.builder
import com.pulumi.aws.redshiftserverless.kotlin.inputs.WorkgroupConfigParameterArgs
import com.pulumi.aws.redshiftserverless.kotlin.inputs.WorkgroupConfigParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Workgroup.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Workgroup("example", {
 *     namespaceName: "concurrency-scaling",
 *     workgroupName: "concurrency-scaling",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Workgroup("example",
 *     namespace_name="concurrency-scaling",
 *     workgroup_name="concurrency-scaling")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Workgroup("example", new()
 *     {
 *         NamespaceName = "concurrency-scaling",
 *         WorkgroupName = "concurrency-scaling",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshiftserverless.NewWorkgroup(ctx, "example", &redshiftserverless.WorkgroupArgs{
 * 			NamespaceName: pulumi.String("concurrency-scaling"),
 * 			WorkgroupName: pulumi.String("concurrency-scaling"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .workgroupName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Workgroup
 *     properties:
 *       namespaceName: concurrency-scaling
 *       workgroupName: concurrency-scaling
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Workgroups using the `workgroup_name`. For example:
 * ```sh
 * $ pulumi import aws:redshiftserverless/workgroup:Workgroup example example
 * ```
 * @property baseCapacity The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
 * @property configParameters An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
 * @property enhancedVpcRouting The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
 * @property maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
 * @property namespaceName The name of the namespace.
 * @property port The port number on which the cluster accepts incoming connections.
 * @property publiclyAccessible A value that specifies whether the workgroup can be accessed from a public network.
 * @property securityGroupIds An array of security group IDs to associate with the workgroup.
 * @property subnetIds An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workgroupName The name of the workgroup.
 * The following arguments are optional:
 */
public data class WorkgroupArgs(
    public val baseCapacity: Output<Int>? = null,
    public val configParameters: Output<List<WorkgroupConfigParameterArgs>>? = null,
    public val enhancedVpcRouting: Output<Boolean>? = null,
    public val maxCapacity: Output<Int>? = null,
    public val namespaceName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.WorkgroupArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.WorkgroupArgs =
        com.pulumi.aws.redshiftserverless.WorkgroupArgs.builder()
            .baseCapacity(baseCapacity?.applyValue({ args0 -> args0 }))
            .configParameters(
                configParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enhancedVpcRouting(enhancedVpcRouting?.applyValue({ args0 -> args0 }))
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupArgs].
 */
@PulumiTagMarker
public class WorkgroupArgsBuilder internal constructor() {
    private var baseCapacity: Output<Int>? = null

    private var configParameters: Output<List<WorkgroupConfigParameterArgs>>? = null

    private var enhancedVpcRouting: Output<Boolean>? = null

    private var maxCapacity: Output<Int>? = null

    private var namespaceName: Output<String>? = null

    private var port: Output<Int>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @JvmName("thahjnnvjqtcsyjd")
    public suspend fun baseCapacity(`value`: Output<Int>) {
        this.baseCapacity = value
    }

    /**
     * @param value An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("ycbxcvykhugqlitc")
    public suspend fun configParameters(`value`: Output<List<WorkgroupConfigParameterArgs>>) {
        this.configParameters = value
    }

    @JvmName("annshlyrgrnopaqu")
    public suspend fun configParameters(vararg values: Output<WorkgroupConfigParameterArgs>) {
        this.configParameters = Output.all(values.asList())
    }

    /**
     * @param values An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("burgwahmjavcpipn")
    public suspend fun configParameters(values: List<Output<WorkgroupConfigParameterArgs>>) {
        this.configParameters = Output.all(values)
    }

    /**
     * @param value The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    @JvmName("wdwlsqdxmcvtrthh")
    public suspend fun enhancedVpcRouting(`value`: Output<Boolean>) {
        this.enhancedVpcRouting = value
    }

    /**
     * @param value The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
     */
    @JvmName("ydllobuvtfrndyct")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("wtxxvqdaskbyiiyk")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The port number on which the cluster accepts incoming connections.
     */
    @JvmName("esucmijnfphjtdxs")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value A value that specifies whether the workgroup can be accessed from a public network.
     */
    @JvmName("dicvoiwcxsqxdugs")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("ownwcwxpnlapafiw")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("uwkdhkynirtwavds")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("aliqjbrxbqxbqalx")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("ixxkygftilsqafhl")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("yvlbyfgnttxkcccd")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("qpjrsjfluwaqrjxr")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wiaevokxyyytykku")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workgroup.
     * The following arguments are optional:
     */
    @JvmName("sajgwixcjoafunui")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @JvmName("iaskujyvpdsaodbc")
    public suspend fun baseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseCapacity = mapped
    }

    /**
     * @param value An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("asbomohtsfgqvfpw")
    public suspend fun configParameters(`value`: List<WorkgroupConfigParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("cwlkrjcetdrefdsp")
    public suspend fun configParameters(argument: List<suspend WorkgroupConfigParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("hkbvfxosebaevxvi")
    public suspend fun configParameters(vararg argument: suspend WorkgroupConfigParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("asvbbgtbxnhuqywi")
    public suspend fun configParameters(argument: suspend WorkgroupConfigParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param values An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("vopdbsygfmtorhoh")
    public suspend fun configParameters(vararg values: WorkgroupConfigParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configParameters = mapped
    }

    /**
     * @param value The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    @JvmName("wfbnplkmkidgfcao")
    public suspend fun enhancedVpcRouting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedVpcRouting = mapped
    }

    /**
     * @param value The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
     */
    @JvmName("gvlfxtqqgbuywjge")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("nqtshflfxacapynj")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The port number on which the cluster accepts incoming connections.
     */
    @JvmName("uvkxvhqfkyiljhgy")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value A value that specifies whether the workgroup can be accessed from a public network.
     */
    @JvmName("cncxxyvbvhmieyxd")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("vchosmixwuhvqmol")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("obeansuiyiwnxjjc")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("hbvepjgdxxcacbtr")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("rveqfkrsjldksiky")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("girtaepbwhjubqqb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ahpphmrolixvhjsr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workgroup.
     * The following arguments are optional:
     */
    @JvmName("qoourtvtbncfjcaf")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): WorkgroupArgs = WorkgroupArgs(
        baseCapacity = baseCapacity,
        configParameters = configParameters,
        enhancedVpcRouting = enhancedVpcRouting,
        maxCapacity = maxCapacity,
        namespaceName = namespaceName,
        port = port,
        publiclyAccessible = publiclyAccessible,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        tags = tags,
        workgroupName = workgroupName,
    )
}
