@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.inputs

import com.pulumi.aws.redshiftserverless.inputs.GetNamespacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNamespace.
 * @property namespaceName The name of the namespace.
 */
public data class GetNamespacePlainArgs(
    public val namespaceName: String,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.inputs.GetNamespacePlainArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.inputs.GetNamespacePlainArgs =
        com.pulumi.aws.redshiftserverless.inputs.GetNamespacePlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespacePlainArgs].
 */
@PulumiTagMarker
public class GetNamespacePlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    /**
     * @param value The name of the namespace.
     */
    @JvmName("ckiyoqlcyeswxgaj")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    internal fun build(): GetNamespacePlainArgs = GetNamespacePlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
    )
}
