@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.inputs

import com.pulumi.aws.redshiftserverless.inputs.GetWorkgroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkgroup.
 * @property workgroupName The name of the workgroup associated with the database.
 */
public data class GetWorkgroupPlainArgs(
    public val workgroupName: String,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.inputs.GetWorkgroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.inputs.GetWorkgroupPlainArgs =
        com.pulumi.aws.redshiftserverless.inputs.GetWorkgroupPlainArgs.builder()
            .workgroupName(workgroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkgroupPlainArgs].
 */
@PulumiTagMarker
public class GetWorkgroupPlainArgsBuilder internal constructor() {
    private var workgroupName: String? = null

    /**
     * @param value The name of the workgroup associated with the database.
     */
    @JvmName("fufeiycxkxbytxaq")
    public suspend fun workgroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workgroupName = mapped
    }

    internal fun build(): GetWorkgroupPlainArgs = GetWorkgroupPlainArgs(
        workgroupName = workgroupName ?: throw PulumiNullFieldException("workgroupName"),
    )
}
