@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property networkInterfaces The network interfaces of the endpoint.. See `Network Interface` below.
 * @property vpcEndpointId The DNS address of the VPC endpoint.
 * @property vpcId The port that Amazon Redshift Serverless listens on.
 */
public data class EndpointAccessVpcEndpoint(
    public val networkInterfaces: List<EndpointAccessVpcEndpointNetworkInterface>? = null,
    public val vpcEndpointId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.EndpointAccessVpcEndpoint): EndpointAccessVpcEndpoint = EndpointAccessVpcEndpoint(
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshiftserverless.kotlin.outputs.EndpointAccessVpcEndpointNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            vpcEndpointId = javaType.vpcEndpointId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
