@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCredentials.
 * @property dbName
 * @property dbPassword Temporary password that authorizes the user name returned by `db_user` to log on to the database `db_name`.
 * @property dbUser A database user name that is authorized to log on to the database `db_name` using the password `db_password` . If the specified `db_user` exists in the database, the new user name has the same database privileges as the user named in `db_user` . By default, the user is added to PUBLIC. the user doesn't exist in the database.
 * @property durationSeconds
 * @property expiration Date and time the password in `db_password` expires.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property workgroupName
 */
public data class GetCredentialsResult(
    public val dbName: String? = null,
    public val dbPassword: String,
    public val dbUser: String,
    public val durationSeconds: Int? = null,
    public val expiration: String,
    public val id: String,
    public val workgroupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetCredentialsResult): GetCredentialsResult = GetCredentialsResult(
            dbName = javaType.dbName().map({ args0 -> args0 }).orElse(null),
            dbPassword = javaType.dbPassword(),
            dbUser = javaType.dbUser(),
            durationSeconds = javaType.durationSeconds().map({ args0 -> args0 }).orElse(null),
            expiration = javaType.expiration(),
            id = javaType.id(),
            workgroupName = javaType.workgroupName(),
        )
    }
}
