@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNamespace.
 * @property adminUsername The username of the administrator for the first database created in the namespace.
 * @property arn Amazon Resource Name (ARN) of the Redshift Serverless Namespace.
 * @property dbName The name of the first database created in the namespace.
 * @property defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
 * @property iamRoles A list of IAM roles to associate with the namespace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
 * @property logExports The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
 * @property namespaceId The Redshift Namespace ID.
 * @property namespaceName
 */
public data class GetNamespaceResult(
    public val adminUsername: String,
    public val arn: String,
    public val dbName: String,
    public val defaultIamRoleArn: String,
    public val iamRoles: List<String>,
    public val id: String,
    public val kmsKeyId: String,
    public val logExports: List<String>,
    public val namespaceId: String,
    public val namespaceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetNamespaceResult): GetNamespaceResult = GetNamespaceResult(
            adminUsername = javaType.adminUsername(),
            arn = javaType.arn(),
            dbName = javaType.dbName(),
            defaultIamRoleArn = javaType.defaultIamRoleArn(),
            iamRoles = javaType.iamRoles().map({ args0 -> args0 }),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            logExports = javaType.logExports().map({ args0 -> args0 }),
            namespaceId = javaType.namespaceId(),
            namespaceName = javaType.namespaceName(),
        )
    }
}
