@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property networkInterfaces The network interfaces of the endpoint.. See `Network Interface` below.
 * @property vpcEndpointId The DNS address of the VPC endpoint.
 * @property vpcId The port that Amazon Redshift Serverless listens on.
 */
public data class GetWorkgroupEndpointVpcEndpoint(
    public val networkInterfaces: List<GetWorkgroupEndpointVpcEndpointNetworkInterface>,
    public val vpcEndpointId: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetWorkgroupEndpointVpcEndpoint): GetWorkgroupEndpointVpcEndpoint = GetWorkgroupEndpointVpcEndpoint(
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshiftserverless.kotlin.outputs.GetWorkgroupEndpointVpcEndpointNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            vpcEndpointId = javaType.vpcEndpointId(),
            vpcId = javaType.vpcId(),
        )
    }
}
