@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The availability Zone.
 * @property networkInterfaceId The unique identifier of the network interface.
 * @property privateIpAddress The IPv4 address of the network interface within the subnet.
 * @property subnetId The unique identifier of the subnet.
 */
public data class GetWorkgroupEndpointVpcEndpointNetworkInterface(
    public val availabilityZone: String,
    public val networkInterfaceId: String,
    public val privateIpAddress: String,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetWorkgroupEndpointVpcEndpointNetworkInterface): GetWorkgroupEndpointVpcEndpointNetworkInterface =
            GetWorkgroupEndpointVpcEndpointNetworkInterface(
                availabilityZone = javaType.availabilityZone(),
                networkInterfaceId = javaType.networkInterfaceId(),
                privateIpAddress = javaType.privateIpAddress(),
                subnetId = javaType.subnetId(),
            )
    }
}
