@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getWorkgroup.
 * @property arn Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
 * @property endpoints The endpoint that is created from the workgroup. See `Endpoint` below.
 * @property enhancedVpcRouting The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namespaceName
 * @property publiclyAccessible A value that specifies whether the workgroup can be accessed from a public network.
 * @property securityGroupIds An array of security group IDs to associate with the workgroup.
 * @property subnetIds An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
 * @property workgroupId The Redshift Workgroup ID.
 * @property workgroupName
 */
public data class GetWorkgroupResult(
    public val arn: String,
    public val endpoints: List<GetWorkgroupEndpoint>,
    public val enhancedVpcRouting: Boolean,
    public val id: String,
    public val namespaceName: String,
    public val publiclyAccessible: Boolean,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val workgroupId: String,
    public val workgroupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetWorkgroupResult): GetWorkgroupResult = GetWorkgroupResult(
            arn = javaType.arn(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshiftserverless.kotlin.outputs.GetWorkgroupEndpoint.Companion.toKotlin(args0)
                })
            }),
            enhancedVpcRouting = javaType.enhancedVpcRouting(),
            id = javaType.id(),
            namespaceName = javaType.namespaceName(),
            publiclyAccessible = javaType.publiclyAccessible(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            workgroupId = javaType.workgroupId(),
            workgroupName = javaType.workgroupName(),
        )
    }
}
