@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterKey The key of the parameter. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, `use_fips_ssl`, and [query monitoring metrics](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) that let you define performance boundaries: `max_query_cpu_time`, `max_query_blocks_read`, `max_scan_row_count`, `max_query_execution_time`, `max_query_queue_time`, `max_query_cpu_usage_percent`, `max_query_temp_blocks_to_disk`, `max_join_row_count` and `max_nested_loop_join_row_count`.
 * @property parameterValue The value of the parameter to set.
 */
public data class WorkgroupConfigParameter(
    public val parameterKey: String,
    public val parameterValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.WorkgroupConfigParameter): WorkgroupConfigParameter = WorkgroupConfigParameter(
            parameterKey = javaType.parameterKey(),
            parameterValue = javaType.parameterValue(),
        )
    }
}
