@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin

import com.pulumi.aws.rekognition.kotlin.outputs.CollectionTimeouts
import com.pulumi.aws.rekognition.kotlin.outputs.CollectionTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Collection].
 */
@PulumiTagMarker
public class CollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CollectionArgs = CollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CollectionArgsBuilder.() -> Unit) {
        val builder = CollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Collection {
        val builtJavaResource = com.pulumi.aws.rekognition.Collection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Collection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Rekognition Collection.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rekognition.Collection("example", {
 *     collectionId: "my-collection",
 *     tags: {
 *         example: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rekognition.Collection("example",
 *     collection_id="my-collection",
 *     tags={
 *         "example": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rekognition.Collection("example", new()
 *     {
 *         CollectionId = "my-collection",
 *         Tags =
 *         {
 *             { "example", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rekognition"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rekognition.NewCollection(ctx, "example", &rekognition.CollectionArgs{
 * 			CollectionId: pulumi.String("my-collection"),
 * 			Tags: pulumi.StringMap{
 * 				"example": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rekognition.Collection;
 * import com.pulumi.aws.rekognition.CollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Collection("example", CollectionArgs.builder()
 *             .collectionId("my-collection")
 *             .tags(Map.of("example", 1))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rekognition:Collection
 *     properties:
 *       collectionId: my-collection
 *       tags:
 *         example: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Rekognition Collection using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:rekognition/collection:Collection example collection-id-12345678
 * ```
 */
public class Collection internal constructor(
    override val javaResource: com.pulumi.aws.rekognition.Collection,
) : KotlinCustomResource(javaResource, CollectionMapper) {
    /**
     * ARN of the Collection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the collection
     * The following arguments are optional:
     */
    public val collectionId: Output<String>
        get() = javaResource.collectionId().applyValue({ args0 -> args0 })

    /**
     * The Face Model Version that the collection was initialized with
     */
    public val faceModelVersion: Output<String>
        get() = javaResource.faceModelVersion().applyValue({ args0 -> args0 })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<CollectionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object CollectionMapper : ResourceMapper<Collection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rekognition.Collection::class == javaResource::class

    override fun map(javaResource: Resource): Collection = Collection(
        javaResource as
            com.pulumi.aws.rekognition.Collection,
    )
}

/**
 * @see [Collection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Collection].
 */
public suspend fun collection(name: String, block: suspend CollectionResourceBuilder.() -> Unit): Collection {
    val builder = CollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Collection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun collection(name: String): Collection {
    val builder = CollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
