@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin

import com.pulumi.aws.rekognition.CollectionArgs.builder
import com.pulumi.aws.rekognition.kotlin.inputs.CollectionTimeoutsArgs
import com.pulumi.aws.rekognition.kotlin.inputs.CollectionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Rekognition Collection.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rekognition.Collection("example", {
 *     collectionId: "my-collection",
 *     tags: {
 *         example: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rekognition.Collection("example",
 *     collection_id="my-collection",
 *     tags={
 *         "example": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rekognition.Collection("example", new()
 *     {
 *         CollectionId = "my-collection",
 *         Tags =
 *         {
 *             { "example", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rekognition"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rekognition.NewCollection(ctx, "example", &rekognition.CollectionArgs{
 * 			CollectionId: pulumi.String("my-collection"),
 * 			Tags: pulumi.StringMap{
 * 				"example": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rekognition.Collection;
 * import com.pulumi.aws.rekognition.CollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Collection("example", CollectionArgs.builder()
 *             .collectionId("my-collection")
 *             .tags(Map.of("example", 1))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rekognition:Collection
 *     properties:
 *       collectionId: my-collection
 *       tags:
 *         example: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Rekognition Collection using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:rekognition/collection:Collection example collection-id-12345678
 * ```
 * @property collectionId The name of the collection
 * The following arguments are optional:
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class CollectionArgs(
    public val collectionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<CollectionTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.CollectionArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.CollectionArgs =
        com.pulumi.aws.rekognition.CollectionArgs.builder()
            .collectionId(collectionId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CollectionArgs].
 */
@PulumiTagMarker
public class CollectionArgsBuilder internal constructor() {
    private var collectionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<CollectionTimeoutsArgs>? = null

    /**
     * @param value The name of the collection
     * The following arguments are optional:
     */
    @JvmName("pjwthdrpqqdjhvys")
    public suspend fun collectionId(`value`: Output<String>) {
        this.collectionId = value
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dhraucqvhiewdcdo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("caegytfxcanuqykw")
    public suspend fun timeouts(`value`: Output<CollectionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The name of the collection
     * The following arguments are optional:
     */
    @JvmName("xswwrmckbuuxcwru")
    public suspend fun collectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionId = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tghevcxniepruclv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lulijqrjyhxuhyjt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("jugkwpcshybliosn")
    public suspend fun timeouts(`value`: CollectionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yynkgkowrsieolnj")
    public suspend fun timeouts(argument: suspend CollectionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = CollectionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): CollectionArgs = CollectionArgs(
        collectionId = collectionId,
        tags = tags,
        timeouts = timeouts,
    )
}
