@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin

import com.pulumi.aws.rekognition.ProjectArgs.builder
import com.pulumi.aws.rekognition.kotlin.inputs.ProjectTimeoutsArgs
import com.pulumi.aws.rekognition.kotlin.inputs.ProjectTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Rekognition Project.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rekognition.Project("example", {
 *     name: "example-project",
 *     autoUpdate: "ENABLED",
 *     feature: "CONTENT_MODERATION",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rekognition.Project("example",
 *     name="example-project",
 *     auto_update="ENABLED",
 *     feature="CONTENT_MODERATION")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rekognition.Project("example", new()
 *     {
 *         Name = "example-project",
 *         AutoUpdate = "ENABLED",
 *         Feature = "CONTENT_MODERATION",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rekognition"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rekognition.NewProject(ctx, "example", &rekognition.ProjectArgs{
 * 			Name:       pulumi.String("example-project"),
 * 			AutoUpdate: pulumi.String("ENABLED"),
 * 			Feature:    pulumi.String("CONTENT_MODERATION"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rekognition.Project;
 * import com.pulumi.aws.rekognition.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example-project")
 *             .autoUpdate("ENABLED")
 *             .feature("CONTENT_MODERATION")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rekognition:Project
 *     properties:
 *       name: example-project
 *       autoUpdate: ENABLED
 *       feature: CONTENT_MODERATION
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Rekognition Project using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rekognition/project:Project example project-id-12345678
 * ```
 * @property autoUpdate Specify if automatic retraining should occur. Valid values are `ENABLED` or `DISABLED`. Defaults to `DISABLED`
 * @property feature Specify the feature being customized. Valid values are `CONTENT_MODERATION` or `CUSTOM_LABELS`. Defaults to `CUSTOM_LABELS`
 * @property name Desired name of the project
 * The following arguments are optional:
 * @property timeouts
 */
public data class ProjectArgs(
    public val autoUpdate: Output<String>? = null,
    public val feature: Output<String>? = null,
    public val name: Output<String>? = null,
    public val timeouts: Output<ProjectTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.ProjectArgs =
        com.pulumi.aws.rekognition.ProjectArgs.builder()
            .autoUpdate(autoUpdate?.applyValue({ args0 -> args0 }))
            .feature(feature?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var autoUpdate: Output<String>? = null

    private var feature: Output<String>? = null

    private var name: Output<String>? = null

    private var timeouts: Output<ProjectTimeoutsArgs>? = null

    /**
     * @param value Specify if automatic retraining should occur. Valid values are `ENABLED` or `DISABLED`. Defaults to `DISABLED`
     */
    @JvmName("owdopficcrqbndrm")
    public suspend fun autoUpdate(`value`: Output<String>) {
        this.autoUpdate = value
    }

    /**
     * @param value Specify the feature being customized. Valid values are `CONTENT_MODERATION` or `CUSTOM_LABELS`. Defaults to `CUSTOM_LABELS`
     */
    @JvmName("uunsedgijbprhkkw")
    public suspend fun feature(`value`: Output<String>) {
        this.feature = value
    }

    /**
     * @param value Desired name of the project
     * The following arguments are optional:
     */
    @JvmName("xjyvdjphjmrvpctl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("abbcubylwpayktmi")
    public suspend fun timeouts(`value`: Output<ProjectTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Specify if automatic retraining should occur. Valid values are `ENABLED` or `DISABLED`. Defaults to `DISABLED`
     */
    @JvmName("gxxccaprfapevclg")
    public suspend fun autoUpdate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpdate = mapped
    }

    /**
     * @param value Specify the feature being customized. Valid values are `CONTENT_MODERATION` or `CUSTOM_LABELS`. Defaults to `CUSTOM_LABELS`
     */
    @JvmName("sdqohicgummebqsj")
    public suspend fun feature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feature = mapped
    }

    /**
     * @param value Desired name of the project
     * The following arguments are optional:
     */
    @JvmName("vqrfjsxfgmyktwuj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqclfcmboiypsxxq")
    public suspend fun timeouts(`value`: ProjectTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xtgitygadhwihswy")
    public suspend fun timeouts(argument: suspend ProjectTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        autoUpdate = autoUpdate,
        feature = feature,
        name = name,
        timeouts = timeouts,
    )
}
