@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorDataSharingPreferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optIn Whether you are sharing data with Rekognition to improve model performance.
 */
public data class StreamProcessorDataSharingPreferenceArgs(
    public val optIn: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorDataSharingPreferenceArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorDataSharingPreferenceArgs = com.pulumi.aws.rekognition.inputs.StreamProcessorDataSharingPreferenceArgs.builder()
        .optIn(optIn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorDataSharingPreferenceArgs].
 */
@PulumiTagMarker
public class StreamProcessorDataSharingPreferenceArgsBuilder internal constructor() {
    private var optIn: Output<Boolean>? = null

    /**
     * @param value Whether you are sharing data with Rekognition to improve model performance.
     */
    @JvmName("nfdyeyfaqrbkpsir")
    public suspend fun optIn(`value`: Output<Boolean>) {
        this.optIn = value
    }

    /**
     * @param value Whether you are sharing data with Rekognition to improve model performance.
     */
    @JvmName("omitfkgrpvtwqmhi")
    public suspend fun optIn(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optIn = mapped
    }

    internal fun build(): StreamProcessorDataSharingPreferenceArgs =
        StreamProcessorDataSharingPreferenceArgs(
            optIn = optIn ?: throw PulumiNullFieldException("optIn"),
        )
}
