@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kinesisVideoStream Kinesis input stream. See `kinesis_video_stream`.
 */
public data class StreamProcessorInputArgs(
    public val kinesisVideoStream: Output<StreamProcessorInputKinesisVideoStreamArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorInputArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorInputArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorInputArgs.builder()
            .kinesisVideoStream(
                kinesisVideoStream?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamProcessorInputArgs].
 */
@PulumiTagMarker
public class StreamProcessorInputArgsBuilder internal constructor() {
    private var kinesisVideoStream: Output<StreamProcessorInputKinesisVideoStreamArgs>? = null

    /**
     * @param value Kinesis input stream. See `kinesis_video_stream`.
     */
    @JvmName("rvpkbgugcrdfokjd")
    public suspend fun kinesisVideoStream(`value`: Output<StreamProcessorInputKinesisVideoStreamArgs>) {
        this.kinesisVideoStream = value
    }

    /**
     * @param value Kinesis input stream. See `kinesis_video_stream`.
     */
    @JvmName("abnxyisqdjijatsa")
    public suspend fun kinesisVideoStream(`value`: StreamProcessorInputKinesisVideoStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisVideoStream = mapped
    }

    /**
     * @param argument Kinesis input stream. See `kinesis_video_stream`.
     */
    @JvmName("bohvdrtjtrggbtxa")
    public suspend fun kinesisVideoStream(argument: suspend StreamProcessorInputKinesisVideoStreamArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorInputKinesisVideoStreamArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisVideoStream = mapped
    }

    internal fun build(): StreamProcessorInputArgs = StreamProcessorInputArgs(
        kinesisVideoStream = kinesisVideoStream,
    )
}
