@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorInputKinesisVideoStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the Kinesis video stream stream that streams the source video.
 */
public data class StreamProcessorInputKinesisVideoStreamArgs(
    public val arn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorInputKinesisVideoStreamArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorInputKinesisVideoStreamArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorInputKinesisVideoStreamArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorInputKinesisVideoStreamArgs].
 */
@PulumiTagMarker
public class StreamProcessorInputKinesisVideoStreamArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value ARN of the Kinesis video stream stream that streams the source video.
     */
    @JvmName("nppcnqfenikkfuaq")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of the Kinesis video stream stream that streams the source video.
     */
    @JvmName("grwmmkwmycltuyom")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): StreamProcessorInputKinesisVideoStreamArgs =
        StreamProcessorInputKinesisVideoStreamArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
        )
}
