@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorNotificationChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property snsTopicArn The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
 */
public data class StreamProcessorNotificationChannelArgs(
    public val snsTopicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorNotificationChannelArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorNotificationChannelArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorNotificationChannelArgs.builder()
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorNotificationChannelArgs].
 */
@PulumiTagMarker
public class StreamProcessorNotificationChannelArgsBuilder internal constructor() {
    private var snsTopicArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
     */
    @JvmName("cuetekimhfhiyrrm")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
     */
    @JvmName("tikikkqfbyqtjhvh")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    internal fun build(): StreamProcessorNotificationChannelArgs =
        StreamProcessorNotificationChannelArgs(
            snsTopicArn = snsTopicArn,
        )
}
