@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorOutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kinesisDataStream The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
 * @property s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
 */
public data class StreamProcessorOutputArgs(
    public val kinesisDataStream: Output<StreamProcessorOutputKinesisDataStreamArgs>? = null,
    public val s3Destination: Output<StreamProcessorOutputS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorOutputArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorOutputArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorOutputArgs.builder()
            .kinesisDataStream(kinesisDataStream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StreamProcessorOutputArgs].
 */
@PulumiTagMarker
public class StreamProcessorOutputArgsBuilder internal constructor() {
    private var kinesisDataStream: Output<StreamProcessorOutputKinesisDataStreamArgs>? = null

    private var s3Destination: Output<StreamProcessorOutputS3DestinationArgs>? = null

    /**
     * @param value The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
     */
    @JvmName("lifpuaqbnntbpqix")
    public suspend fun kinesisDataStream(`value`: Output<StreamProcessorOutputKinesisDataStreamArgs>) {
        this.kinesisDataStream = value
    }

    /**
     * @param value The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
     */
    @JvmName("dklmskeieaskspbv")
    public suspend fun s3Destination(`value`: Output<StreamProcessorOutputS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
     */
    @JvmName("gsndsbjtfpcexaxc")
    public suspend fun kinesisDataStream(`value`: StreamProcessorOutputKinesisDataStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisDataStream = mapped
    }

    /**
     * @param argument The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
     */
    @JvmName("ywloptsrngufmcgw")
    public suspend fun kinesisDataStream(argument: suspend StreamProcessorOutputKinesisDataStreamArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorOutputKinesisDataStreamArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisDataStream = mapped
    }

    /**
     * @param value The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
     */
    @JvmName("phmjpnlobanowhtm")
    public suspend fun s3Destination(`value`: StreamProcessorOutputS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
     */
    @JvmName("kpwnuyqiclalqpqb")
    public suspend fun s3Destination(argument: suspend StreamProcessorOutputS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorOutputS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): StreamProcessorOutputArgs = StreamProcessorOutputArgs(
        kinesisDataStream = kinesisDataStream,
        s3Destination = s3Destination,
    )
}
