@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorOutputKinesisDataStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the output Amazon Kinesis Data Streams stream.
 */
public data class StreamProcessorOutputKinesisDataStreamArgs(
    public val arn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorOutputKinesisDataStreamArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorOutputKinesisDataStreamArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorOutputKinesisDataStreamArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorOutputKinesisDataStreamArgs].
 */
@PulumiTagMarker
public class StreamProcessorOutputKinesisDataStreamArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value ARN of the output Amazon Kinesis Data Streams stream.
     */
    @JvmName("tfnixghvoyveycli")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of the output Amazon Kinesis Data Streams stream.
     */
    @JvmName("evmxksacmuljqhkw")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): StreamProcessorOutputKinesisDataStreamArgs =
        StreamProcessorOutputKinesisDataStreamArgs(
            arn = arn,
        )
}
