@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorOutputS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of the Amazon S3 bucket you want to associate with the streaming video project.
 * @property keyPrefix The prefix value of the location within the bucket that you want the information to be published to.
 */
public data class StreamProcessorOutputS3DestinationArgs(
    public val bucket: Output<String>? = null,
    public val keyPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorOutputS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorOutputS3DestinationArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorOutputS3DestinationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .keyPrefix(keyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorOutputS3DestinationArgs].
 */
@PulumiTagMarker
public class StreamProcessorOutputS3DestinationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var keyPrefix: Output<String>? = null

    /**
     * @param value Name of the Amazon S3 bucket you want to associate with the streaming video project.
     */
    @JvmName("vfatsoeijufbxlft")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The prefix value of the location within the bucket that you want the information to be published to.
     */
    @JvmName("dhfsbgeiusttmunf")
    public suspend fun keyPrefix(`value`: Output<String>) {
        this.keyPrefix = value
    }

    /**
     * @param value Name of the Amazon S3 bucket you want to associate with the streaming video project.
     */
    @JvmName("cbkojrxqafxacort")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The prefix value of the location within the bucket that you want the information to be published to.
     */
    @JvmName("uicuxlytxwscgsqw")
    public suspend fun keyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefix = mapped
    }

    internal fun build(): StreamProcessorOutputS3DestinationArgs =
        StreamProcessorOutputS3DestinationArgs(
            bucket = bucket,
            keyPrefix = keyPrefix,
        )
}
