@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property boundingBox Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
 * @property polygons Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
 */
public data class StreamProcessorRegionsOfInterestArgs(
    public val boundingBox: Output<StreamProcessorRegionsOfInterestBoundingBoxArgs>? = null,
    public val polygons: Output<List<StreamProcessorRegionsOfInterestPolygonArgs>>,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestArgs.builder()
            .boundingBox(boundingBox?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .polygons(
                polygons.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamProcessorRegionsOfInterestArgs].
 */
@PulumiTagMarker
public class StreamProcessorRegionsOfInterestArgsBuilder internal constructor() {
    private var boundingBox: Output<StreamProcessorRegionsOfInterestBoundingBoxArgs>? = null

    private var polygons: Output<List<StreamProcessorRegionsOfInterestPolygonArgs>>? = null

    /**
     * @param value Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
     */
    @JvmName("bmcxldfvtlpnmfya")
    public suspend fun boundingBox(`value`: Output<StreamProcessorRegionsOfInterestBoundingBoxArgs>) {
        this.boundingBox = value
    }

    /**
     * @param value Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("upvtaqtjanuwybhc")
    public suspend fun polygons(`value`: Output<List<StreamProcessorRegionsOfInterestPolygonArgs>>) {
        this.polygons = value
    }

    @JvmName("aqtqgdamiluwgfjb")
    public suspend fun polygons(vararg values: Output<StreamProcessorRegionsOfInterestPolygonArgs>) {
        this.polygons = Output.all(values.asList())
    }

    /**
     * @param values Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("dtjtntvunbvxbjbv")
    public suspend fun polygons(values: List<Output<StreamProcessorRegionsOfInterestPolygonArgs>>) {
        this.polygons = Output.all(values)
    }

    /**
     * @param value Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
     */
    @JvmName("ircrikbcykecdjlt")
    public suspend fun boundingBox(`value`: StreamProcessorRegionsOfInterestBoundingBoxArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boundingBox = mapped
    }

    /**
     * @param argument Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
     */
    @JvmName("njefismbnehumstx")
    public suspend fun boundingBox(argument: suspend StreamProcessorRegionsOfInterestBoundingBoxArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorRegionsOfInterestBoundingBoxArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.boundingBox = mapped
    }

    /**
     * @param value Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("vwopkkrxysfkwyat")
    public suspend fun polygons(`value`: List<StreamProcessorRegionsOfInterestPolygonArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polygons = mapped
    }

    /**
     * @param argument Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("xjmvvqqwvyvgupxk")
    public suspend fun polygons(argument: List<suspend StreamProcessorRegionsOfInterestPolygonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StreamProcessorRegionsOfInterestPolygonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.polygons = mapped
    }

    /**
     * @param argument Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("fcblccabdhntojyx")
    public suspend fun polygons(vararg argument: suspend StreamProcessorRegionsOfInterestPolygonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StreamProcessorRegionsOfInterestPolygonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.polygons = mapped
    }

    /**
     * @param argument Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("bywvldggpttvloac")
    public suspend fun polygons(argument: suspend StreamProcessorRegionsOfInterestPolygonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StreamProcessorRegionsOfInterestPolygonArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.polygons = mapped
    }

    /**
     * @param values Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
     */
    @JvmName("cttvskqjlqfglugh")
    public suspend fun polygons(vararg values: StreamProcessorRegionsOfInterestPolygonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polygons = mapped
    }

    internal fun build(): StreamProcessorRegionsOfInterestArgs = StreamProcessorRegionsOfInterestArgs(
        boundingBox = boundingBox,
        polygons = polygons ?: throw PulumiNullFieldException("polygons"),
    )
}
