@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestBoundingBoxArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property height Height of the bounding box as a ratio of the overall image height.
 * @property left Left coordinate of the bounding box as a ratio of overall image width.
 * @property top Top coordinate of the bounding box as a ratio of overall image height.
 * @property width Width of the bounding box as a ratio of the overall image width.
 */
public data class StreamProcessorRegionsOfInterestBoundingBoxArgs(
    public val height: Output<Double>? = null,
    public val left: Output<Double>? = null,
    public val top: Output<Double>? = null,
    public val width: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestBoundingBoxArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestBoundingBoxArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestBoundingBoxArgs.builder()
            .height(height?.applyValue({ args0 -> args0 }))
            .left(left?.applyValue({ args0 -> args0 }))
            .top(top?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorRegionsOfInterestBoundingBoxArgs].
 */
@PulumiTagMarker
public class StreamProcessorRegionsOfInterestBoundingBoxArgsBuilder internal constructor() {
    private var height: Output<Double>? = null

    private var left: Output<Double>? = null

    private var top: Output<Double>? = null

    private var width: Output<Double>? = null

    /**
     * @param value Height of the bounding box as a ratio of the overall image height.
     */
    @JvmName("xmgoipnmkvcxodup")
    public suspend fun height(`value`: Output<Double>) {
        this.height = value
    }

    /**
     * @param value Left coordinate of the bounding box as a ratio of overall image width.
     */
    @JvmName("nojasejsubebnprg")
    public suspend fun left(`value`: Output<Double>) {
        this.left = value
    }

    /**
     * @param value Top coordinate of the bounding box as a ratio of overall image height.
     */
    @JvmName("fbfgkvwvabfyyiuc")
    public suspend fun top(`value`: Output<Double>) {
        this.top = value
    }

    /**
     * @param value Width of the bounding box as a ratio of the overall image width.
     */
    @JvmName("ypmvhvndcpicwvwk")
    public suspend fun width(`value`: Output<Double>) {
        this.width = value
    }

    /**
     * @param value Height of the bounding box as a ratio of the overall image height.
     */
    @JvmName("yvyebpfntkdauwkw")
    public suspend fun height(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value Left coordinate of the bounding box as a ratio of overall image width.
     */
    @JvmName("lgsgslyhyluosldc")
    public suspend fun left(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.left = mapped
    }

    /**
     * @param value Top coordinate of the bounding box as a ratio of overall image height.
     */
    @JvmName("pwtbgfmtyskagukf")
    public suspend fun top(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.top = mapped
    }

    /**
     * @param value Width of the bounding box as a ratio of the overall image width.
     */
    @JvmName("kdlmhwlrthkijwqf")
    public suspend fun width(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): StreamProcessorRegionsOfInterestBoundingBoxArgs =
        StreamProcessorRegionsOfInterestBoundingBoxArgs(
            height = height,
            left = left,
            top = top,
            width = width,
        )
}
