@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestPolygonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property x The value of the X coordinate for a point on a Polygon.
 * @property y The value of the Y coordinate for a point on a Polygon.
 */
public data class StreamProcessorRegionsOfInterestPolygonArgs(
    public val x: Output<Double>? = null,
    public val y: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestPolygonArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestPolygonArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorRegionsOfInterestPolygonArgs.builder()
            .x(x?.applyValue({ args0 -> args0 }))
            .y(y?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorRegionsOfInterestPolygonArgs].
 */
@PulumiTagMarker
public class StreamProcessorRegionsOfInterestPolygonArgsBuilder internal constructor() {
    private var x: Output<Double>? = null

    private var y: Output<Double>? = null

    /**
     * @param value The value of the X coordinate for a point on a Polygon.
     */
    @JvmName("lhbhyekyeepgttbd")
    public suspend fun x(`value`: Output<Double>) {
        this.x = value
    }

    /**
     * @param value The value of the Y coordinate for a point on a Polygon.
     */
    @JvmName("ikmpsmofbaqrudnj")
    public suspend fun y(`value`: Output<Double>) {
        this.y = value
    }

    /**
     * @param value The value of the X coordinate for a point on a Polygon.
     */
    @JvmName("qlcpkbkdwetuiwym")
    public suspend fun x(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x = mapped
    }

    /**
     * @param value The value of the Y coordinate for a point on a Polygon.
     */
    @JvmName("lhtoncknbjgtxywc")
    public suspend fun y(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.y = mapped
    }

    internal fun build(): StreamProcessorRegionsOfInterestPolygonArgs =
        StreamProcessorRegionsOfInterestPolygonArgs(
            x = x,
            y = y,
        )
}
