@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectedHome Label detection settings to use on a streaming video. See `connected_home`.
 * @property faceSearch Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
 */
public data class StreamProcessorSettingsArgs(
    public val connectedHome: Output<StreamProcessorSettingsConnectedHomeArgs>? = null,
    public val faceSearch: Output<StreamProcessorSettingsFaceSearchArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsArgs.builder()
            .connectedHome(connectedHome?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .faceSearch(faceSearch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StreamProcessorSettingsArgs].
 */
@PulumiTagMarker
public class StreamProcessorSettingsArgsBuilder internal constructor() {
    private var connectedHome: Output<StreamProcessorSettingsConnectedHomeArgs>? = null

    private var faceSearch: Output<StreamProcessorSettingsFaceSearchArgs>? = null

    /**
     * @param value Label detection settings to use on a streaming video. See `connected_home`.
     */
    @JvmName("xtmukkktujconyvt")
    public suspend fun connectedHome(`value`: Output<StreamProcessorSettingsConnectedHomeArgs>) {
        this.connectedHome = value
    }

    /**
     * @param value Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
     */
    @JvmName("cahesoiglpvhyibs")
    public suspend fun faceSearch(`value`: Output<StreamProcessorSettingsFaceSearchArgs>) {
        this.faceSearch = value
    }

    /**
     * @param value Label detection settings to use on a streaming video. See `connected_home`.
     */
    @JvmName("damhtxvqkpcydaxc")
    public suspend fun connectedHome(`value`: StreamProcessorSettingsConnectedHomeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedHome = mapped
    }

    /**
     * @param argument Label detection settings to use on a streaming video. See `connected_home`.
     */
    @JvmName("oihibyibfpcidmbw")
    public suspend fun connectedHome(argument: suspend StreamProcessorSettingsConnectedHomeArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorSettingsConnectedHomeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectedHome = mapped
    }

    /**
     * @param value Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
     */
    @JvmName("cxodqgritaunlwbm")
    public suspend fun faceSearch(`value`: StreamProcessorSettingsFaceSearchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.faceSearch = mapped
    }

    /**
     * @param argument Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
     */
    @JvmName("desdmyfmillajhjg")
    public suspend fun faceSearch(argument: suspend StreamProcessorSettingsFaceSearchArgsBuilder.() -> Unit) {
        val toBeMapped = StreamProcessorSettingsFaceSearchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.faceSearch = mapped
    }

    internal fun build(): StreamProcessorSettingsArgs = StreamProcessorSettingsArgs(
        connectedHome = connectedHome,
        faceSearch = faceSearch,
    )
}
