@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsConnectedHomeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property labels Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
 * @property minConfidence Minimum confidence required to label an object in the video.
 */
public data class StreamProcessorSettingsConnectedHomeArgs(
    public val labels: Output<List<String>>? = null,
    public val minConfidence: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsConnectedHomeArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsConnectedHomeArgs = com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsConnectedHomeArgs.builder()
        .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .minConfidence(minConfidence?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorSettingsConnectedHomeArgs].
 */
@PulumiTagMarker
public class StreamProcessorSettingsConnectedHomeArgsBuilder internal constructor() {
    private var labels: Output<List<String>>? = null

    private var minConfidence: Output<Double>? = null

    /**
     * @param value Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
     */
    @JvmName("vnjjpxekmbmssilx")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("kohjlmjwxghcsqyf")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
     */
    @JvmName("ikbdmrdxcdrnltgb")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Minimum confidence required to label an object in the video.
     */
    @JvmName("tikiwuoxaolirpbc")
    public suspend fun minConfidence(`value`: Output<Double>) {
        this.minConfidence = value
    }

    /**
     * @param value Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
     */
    @JvmName("imqgpprujyesfsth")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
     */
    @JvmName("hynrrdehcmfaixch")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Minimum confidence required to label an object in the video.
     */
    @JvmName("gpwaokfexkfhxqvv")
    public suspend fun minConfidence(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minConfidence = mapped
    }

    internal fun build(): StreamProcessorSettingsConnectedHomeArgs =
        StreamProcessorSettingsConnectedHomeArgs(
            labels = labels,
            minConfidence = minConfidence,
        )
}
